/* created on 26 Oct, 2004 by Ying Wang
 * Using adjacent matrix to represent graph*/

#include "Main.h"

int main(int argc, char* argv[])
{
  if(argc!=1)
  { cerr<<"wrong number of arguments"<<endl; exit(-1); }

   time_t seed = time(NULL);
   srand((unsigned)seed);
   long* seedptr=new long;
   if(seedptr==NULL)
   { cout<<"Out of memory."<<endl;  exit(-1); }

   clock_t start,end;
   start = clock();

   //Load parameters
   int datatype;
   int numDis, numNormal;  //sample size
   long N0; double grate; //current population size, population growth rate
   double sco; int mutage; 
   double lowbound, highbound;
   double intervsize; //in Mb
   int markertype = SNP;
   double mu, mutloc, strpden;
   int homorec; int useIceland=0;
   double cutofflevel;
   int nmarker_limit;
   int simuRep;
   double f_DD, f_DN, f_NN;
   int whichchrom; long leftend, rightend;
   double init_gbm, drift_gbm, var_gbm;
   int printRecs;
   int computeLDs;
     
 
   //Input parameters from file
   string dtype;  
   cout<<"Genotype data or haplotype data (enter h or g):"<<endl;
   cin>>dtype;
   while(dtype.length()!=1 || ((dtype[0]!='h' && dtype[0]!='H') && (dtype[0]!='g' && dtype[0]!='G'))) {cout<<"enter h or g:"<<endl; cin>>dtype; }
   if(dtype[0] == 'h' || dtype[0] == 'H') datatype = HAPLOTYPE; else datatype = GENOTYPE;

   if(datatype==GENOTYPE)
   {
      //Penetrance parameters
      cout<<"Penetrance parameters for genotypes DD:"<<endl;  cin>>f_DD;
      while(f_DD<0 || f_DD>1){ cout<<"penetrance parameters should be between 0 and 1 (inclusive):"<<endl; cin>>f_DD;}
      
      cout<<"Penetrance parameters for genotypes D+:"<<endl; cin>>f_DN;
      while(f_DN<0 || f_DN>1){ cout<<"penetrance parameters should be between 0 and 1 (inclusive):"<<endl; cin>>f_DN;}
      
      cout<<"Penetrance parameters for genotypes ++:"<<endl; cin>>f_NN;
      while(f_NN<0 || f_NN>1){ cout<<"penetrance parameters should be between 0 and 1 (inclusive):"<<endl; cin>>f_NN;}
    }

    //# disease
    cout<<"Number of disease individuals:"<<endl;
    double tmp_input; cin>>tmp_input;
    numDis = (int)tmp_input;
    while(numDis<0){cout<<"# of disease individuals should be 0 or positive integers:"<<endl; cin>>tmp_input;numDis = (int)tmp_input;}
    
    //# normal
    cout<<"Number of normal controls:"<<endl;
    cin>>tmp_input;
    numNormal = (int)tmp_input;
    while(numNormal<=0){cout<<"# of normal individuals should be positive integers:"<<endl; cin>>tmp_input;numNormal = (int)tmp_input;}

    //N0
    cout<<"Present-day population size:"<<endl;
    cin>>tmp_input; N0 = (long)tmp_input;
    while(N0<=0 || N0>=1000000000){cout<<"Current population size should be >0 and <10^9:"<<endl; cin>>tmp_input; N0 = (long)tmp_input;}    

    //grate
    cout<<"Exponentially growth rate:"<<endl;
    cin>>grate; 
    
    //mutage
    cout<<"Age of disease mutation:"<<endl;
    cin>>tmp_input; mutage = (int)tmp_input;
    while(mutage<0){cout<<"Mutation age should be positive integers:"<<endl; cin>>tmp_input; mutage = (int)tmp_input;}
     
    //sco 
    cout<<"Selection coefficient of the disease-mutation:"<<endl;
    cin>>sco;  
   
    //check N0, grate, mutage, and sco
    double nt =N0*exp(-grate*mutage);  double prop=0; 
    if(nt>=2){ prop =  checkSamplePath(N0, grate, mutage, sco, seedptr);}
    while(nt<2 || prop!=0)
    {
	if(nt<2)
	{
	    cout<<"The population size is "<<nt<<" at which the disease arose."<<endl;
            cout<<"It has to be >=2."<<endl;
	}
	else
	{
	    cout<<"The proportion of the loss of the disease allele is "<<prop<<" (>99%)"<<endl;
            cout<<"Please modify the parameters(current population size and/or growth rate and/or disease-mutation age and/or selection coefficient)."<<endl;
	}
	//N0
	cout<<"Present-day population size:"<<endl;
        cin>>tmp_input;  N0 = (long)tmp_input;
        while(N0<=0){cout<<"Current population size should be positive integers:"<<endl; cin>>tmp_input;  N0 = (long)tmp_input;}
	//grate
        cout<<"Exponentially growth rate:"<<endl;
        cin>>grate;
	//age
	cout<<"Age of disease mutation:"<<endl;
        cin>>tmp_input; mutage = (int)tmp_input;
        while(mutage<0){cout<<"Mutation age should be positive integers:"<<endl; cin>>tmp_input; mutage = (int)tmp_input;}
	//sco
	cout<<"Selection coefficient of the disease-mutation:"<<endl;
	cin>>sco;
	nt =N0*exp(-grate*mutage); 
	if(nt>=2){ prop =  checkSamplePath(N0, grate, mutage, sco, seedptr);}
    }


    //lowbound
    cout<<"Low boundary of the disease allele frequency:"<<endl;
    cin>>lowbound;
    while(lowbound<0){cout<<"Low boundary must be >=0 :"<<endl; cin>>tmp_input; lowbound = (int)tmp_input;}
    
    //highbound
    cout<<"High boundary of the disease allele frequency:"<<endl;
    cin>>highbound;
    while(highbound>1){cout<<"High boundary must be <=1 :"<<endl;  cin>>tmp_input; highbound = (int)tmp_input;}

    //homorec
    cout<<"Assuming homogeneous recombination rate (1 or 0):"<<endl;
    cin>>tmp_input; homorec = (int)tmp_input;
    while(homorec!=1 && homorec!=0){ cout<<"It has to be 1 or 0:"<<endl; cin>>tmp_input; homorec = (int)tmp_input;}
    if(!homorec)
    {
         cout<<"Using Icelandic data (1 or 0):"<<endl;
         cin>>tmp_input; useIceland = (int)tmp_input;
         while(useIceland!=1 && useIceland!=0){ cout<<"It has to be 1 or 0:"<<endl; cin>>tmp_input; useIceland = (int)tmp_input;}
         if(useIceland)
         {
            cout<<"For which chromosome (1-22):"<<endl;
            cin>>tmp_input; whichchrom = (int)tmp_input;
            while(whichchrom<1 || whichchrom>22){cout<<"for chromosome 1-22:"<<endl;  cin>>tmp_input; whichchrom = (int)tmp_input;}
            //get range of the chromosome
            //get file name
            char fname[20] = "deCODEMap/MapChr";
            char append[3];
            if(whichchrom<10){ append[0] = 48+whichchrom; append[1]='\0';}
            else {append[0] = 48+(whichchrom/10); append[1] = 48+(whichchrom%10); append[2]='\0';}
            strcat(fname, append);

            ifstream ifs;
            ifs.open(fname, ios::in);
            if(!ifs){ cout<<"The icelandic data: "<<fname<<" can not be opened!"<<endl;
            exit(1);}
            ifs.seekg(0L,ios::beg);
            double totleft, totright; ifs>>totleft; ifs>>totright;
            cout<<"Total region: "<<totleft<<"\t"<<totright<<endl;
            ifs.close();

            cout<<"Left boundary of the chromosomal interval:"<<endl;
            cin>>tmp_input; leftend = (long)tmp_input;

            cout<<"right boundary of the chromosomal interval:"<<endl;
            cin>>tmp_input; rightend = (long)tmp_input;

            intervsize =double( rightend-leftend)/1000000; //in Mb
            cout<<"Interval size: "<<intervsize<<endl;
            while(leftend<totleft || rightend>totright || leftend>=rightend ||
                        (intervsize>0.5 && grate<=0.005)||(intervsize>4 && grate>0.005))
            {
                if(leftend<totleft || rightend>totright || leftend>=rightend)
                   cout<<"The chromosomal region should be within the total available region."<<endl;
                else if(intervsize>0.5 && grate<=0.005)
                    cout<<"The size of the chromosome interval should be <=0.5 for a population with growth rate <= 0.005."<<endl;
                else if(intervsize>4&& grate>0.005)
                    cout<<"The size of the chromosome interval should be <=4 for a population with growth rate > 0.005."<<endl;
                cout<<"Left boundary of the chromosomal interval:"<<endl;
                cin>>tmp_input; leftend = (long)tmp_input;
                cout<<"right boundary of the chromosomal interval:"<<endl;
                cin>>tmp_input; rightend = (long)tmp_input;
                intervsize =double( rightend-leftend)/1000000;
                cout<<"Interval size: "<<intervsize<<endl;
            }
         }
         else
         {
            cout<<"Initial recombination rate (cM/Mb):"<<endl;
            cin>>init_gbm;
            while(init_gbm<=0 || init_gbm>=5){ cout<<"Initial recombination rate should be between 0 and 5 (exclusive)"<<endl; cin>>init_gbm;}

            cout<<"Drift parameter for the GBM: "<<endl;
            cin>>drift_gbm;
            while(drift_gbm>0.0000001){cout<<"Drift parameter should be less than 10^(-7):"<<endl;  cin>>drift_gbm;}

            cout<<"Diffusion parameter for the GBM:"<<endl;
            cin>>var_gbm;
            while(var_gbm>0.0000001){cout<<"Diffusion parameter should be less than 10^(-7):"<<endl;  cin>>var_gbm;}
         }
    }
   if(!useIceland)
   {
       cout<<"Chromosome interval size (Mb):"<<endl; cin>>intervsize;
       
       while((intervsize>0.5 && grate<=0.005) || (intervsize>4&& grate>0.005))
       {
          if(intervsize>0.5 && grate<=0.005)
	     cout<<"The size of the chromosome interval should be <=0.5 for a population with growth rate <= 0.005."<<endl;
          else if(intervsize>4&& grate>0.005)
	     cout<<"The size of the chromosome interval should be <=4 for a population with growth rate > 0.005."<<endl;
          cout<<"Chromosome interval size (Mb):"<<endl; cin>>intervsize;
       }
   }
 
    //mutloc
    cout<<"Disease-mutation location (Mb):"<<endl;
    cin>>mutloc;
    while(mutloc<0 || mutloc>intervsize){ cout<<"Disease-mutation locatin should be between 0 and the size of the interval:"<<endl;
    cin>>mutloc;}

    //marker type
    string mtype;
    cout<<"Marker type [enter s (for SNP) or m (for STRP)]:"<<endl;
    cin>>mtype;
    while(mtype.length()!=1 || ((mtype[0]!='s'&&mtype[0]!='S') && (mtype[0]!='m'&&mtype[0]!='M'))){ cout<<"Enter s or m for marker type:"<<endl; cin>>mtype;}
    if(mtype[0] == 's' || mtype[0]=='S') markertype = SNP; else markertype = STRP;
 
    //mu
    cout<<"Marker mutation rate:"<<endl;
    cin>>mu;
    while(markertype==SNP && (mu<0.000000001 || mu>0.000001))
    {cout<<"Mutation rate for SNP should be between 10^(-9) and 10^(-6):"<<endl; cin>>mu;}
    while(markertype==STRP && (mu<0.00001 || mu>0.01))
    {cout<<"Mutation rate for STRP should be between 10^(-5) and 10^(-2):"<<endl; cin>>mu;}
 
    //strp density
    if(markertype == STRP)
    {
       cout<<"STRP Marker density (per Mb):"<<endl; cin>>strpden;
       while(strpden<0 || strpden>1000){cout<<"STRP density should be between 0 and 1000"; cin>>strpden;}
    }

       
    //marker cutoff level
    cout<<"Marker cut-off level:"<<endl;
    cin>>cutofflevel;
    while(cutofflevel<0 || cutofflevel>=1)
    { cout<<"The markers cutoff level should be between 0 (inclusive) and 1 (exclusive):"<<endl; cin>>cutofflevel;} 

    //minimum # of markers
    cout<<"Minimum number of markers:"<<endl;
    cin>>tmp_input; nmarker_limit= (int)tmp_input;
    while(nmarker_limit<0){cout<<"The minimum number of markers should be >= 0:"<<endl;cin>>tmp_input; nmarker_limit= (int)tmp_input;}
 
    //# of replicates
    cout<<"Number of replicates:"<<endl;
    cin>>tmp_input; simuRep = (int)tmp_input;
    while(simuRep<=0) {cout<<"# of replicates should be >0:"<<endl; cin>>tmp_input; simuRep = (int)tmp_input;} 
 
    //output file name	
    char outputfile[50];
    cout<<"Output file name (<50 characters):"<<endl;
    cin>>outputfile;

    //print recom-rate
    cout<<"Print recombination rates (1 or 0):"<<endl;
    cin>>tmp_input; printRecs = (int)tmp_input;
    while(printRecs!=0 && printRecs!=1) {cout<<"Enter 1 or 0:"<<endl;cin>>tmp_input; printRecs = (int)tmp_input;}

    //compute LDs
    cout<<"Compute pairwise LDs between the disease mutation and markers (enter 1), or not (enter 0):"<<endl;
    cin>>tmp_input; computeLDs = (int)tmp_input;
    while(computeLDs!=0 && computeLDs!=1) {cout<<"Enter 1 or 0:"<<endl;cin>>tmp_input; computeLDs = (int)tmp_input;}

    //LDs file name
    char ldsfile[50];
    if(computeLDs==1){ cout<<"Name of the file for saving pairwise LDs ((<50 characters):"<<endl;  cin>>ldsfile; }

   //---------------finishing reading in parameters--------------------------------------------


 
    ofstream ofs;
    strcat(outputfile, ".xml");
    ofs.open(outputfile);
    if (!ofs){
        cerr<<outputfile<<" can't be opened."<<endl;
        exit(-1);
    }
    ofs<<"<?xml version=\"1.0\"?>"<<endl;
    ofs<<"<DATA>"<<endl;
 
    ofstream oflds; 
    if(computeLDs==1)
    {
	strcat(ldsfile, ".xml");
        oflds.open(ldsfile);
         if (!oflds){
           cerr<<ldsfile<<" can't be opened for writing."<<endl;
           exit(-1);
         }
	 oflds<<"<?xml version=\"1.0\"?>"<<endl;
         oflds<<"<DATA>"<<endl;
    }	 

    //output parameters to file
    ofs<<"<Parameters>"<<endl;
    ofs<<"<datatype>"<<datatype<<"</datatype>"<<endl;
    if(datatype == GENOTYPE)
    {  ofs<<"<f_DD>"<<f_DD<<"</f_DD>"<<endl; ofs<<"<f_DN>"<<f_DN<<"</f_DN>"<<endl;
       ofs<<"<f_NN>"<<f_NN<<"</f_NN>"<<endl;}
    ofs<<"<num_disease>"<<numDis<<"</num_disease>"<<endl;
    ofs<<"<num_normal>"<<numNormal<<"</num_normal>"<<endl;
    ofs<<"<population_size>"<<N0<<"</population_size>"<<endl;
    ofs<<"<growth_rate>"<<grate<<"</growth_rate>"<<endl;
    ofs<<"<disease_age>"<<mutage<<"</disease_age>"<<endl;
    ofs<<"<selection_coeff>"<<sco<<"</selection_coeff>"<<endl;
    ofs<<"<lowbound_freq>"<<lowbound<<"</lowbound_freq>"<<endl;
    ofs<<"<highbound_freq>"<<highbound<<"</highbound_freq>"<<endl;
    ofs<<"<interval_size>"<<intervsize<<"</interval_size>"<<endl;
    ofs<<"<mutation_location>"<<mutloc<<"</mutation_location>"<<endl;
    ofs<<"<homorecmodel>"<<homorec<<"</homorecmodel>"<<endl;
    if(!homorec)
    {
        if(useIceland){
           ofs<<"<chromosome>"<<whichchrom<<"</chromosome>"<<endl;
           ofs<<"<leftend_region>"<<leftend<<"</leftend_region>"<<endl;
           ofs<<"<rightend_region>"<<rightend<<"</rightend_region>"<<endl;
        }
        else{
           ofs<<"<initial_rate>"<<init_gbm<<"</initial_rate>"<<endl;
           ofs<<"<drift_gbm>"<<drift_gbm<<"</drift_gbm>"<<endl; ofs<<"<var_gbm>"<<var_gbm<<"</var_gbm>"<<endl;
        }
    }
    ofs<<"<marker_type>"<<markertype<<"</marker_type>"<<endl;
    ofs<<"<mutation_rate>"<<mu<<"</mutation_rate>"<<endl;
    if(markertype== STRP) ofs<<"<strp_density>"<<strpden<<"</strp_density>"<<endl;
    ofs<<"<cutoff_level>"<<cutofflevel<<"</cutoff_level>"<<endl;
    ofs<<"<limit_minimumMarkers>"<<nmarker_limit<<"</limit_minimumMarkers>"<<endl;
    ofs<<"<num_replicates>"<<simuRep<<"</num_replicates>"<<endl;
    ofs<<"</Parameters>"<<endl;
  
    cout<<"\nThe input parameters have been written into the file "<<outputfile<<endl;
    cout<<"Running the simulation program..."<<endl;

   //checking average 
   double aveTMRCA=0;  double aveDisTMRCA=0; double totTime=0; int totMuts=0; int totMarkers=0;
   int nrec=0; int nrecDis=0; double aveDisFreq=0;
   int miniNumMarkers=-1;  //the minimum # markers among all simulated replicates
   int count=1;  int numRejects =0;
   while(count<=simuRep)
   {
	*seedptr = -1*rand();
        Graph G(datatype, numDis, numNormal, N0, grate, sco, mutage, intervsize, markertype, mu, strpden, mutloc, homorec, useIceland, cutofflevel, nmarker_limit);
	if(datatype==GENOTYPE) G.setPenetrParams(f_DD, f_DN, f_NN);
	if(!homorec)
	{
	   if(useIceland) G.setIcelandParams(whichchrom, leftend, rightend);
	   else   G.setGBMParams(init_gbm, drift_gbm, var_gbm); 
	}
	bool want = G.simuGenealogy(lowbound, highbound, seedptr);
   	if(!want)
	{ 
	   numRejects++;
	   if(numRejects>=100 && (double)numRejects/(double)(numRejects+count)>0.95)   
	   {
	     cout<<"The proportion of rejected simulations is "<<(double)numRejects/(double)(numRejects+count);
	     cout<<" (greater than 95%). "<<endl;	
	     cout<<"The program was terminated."<<endl;
	     exit(-1);	
	   }
	   continue;
	}

	aveTMRCA += G.getTMRCA();
	aveDisTMRCA += G.getTMRCAdis();
	totTime += G.getTotalTime();
	nrec += G.getnumRecs();
	nrecDis += G.getnumRecsDis();
	totMuts += G.getnumMutations();
	totMarkers += G.getnumMarkers();
	aveDisFreq += G.currentDisFreq();

	int** realseqmatr = G.getRealSampleSeqMatr();
        vector<double> realmapdis = G.getRealMarkerPosit();
 	int nmarkers = realmapdis.size();	
	if(miniNumMarkers==-1){ miniNumMarkers = nmarkers;}
	else if(miniNumMarkers > nmarkers) { miniNumMarkers = nmarkers;}

	//compute LDs between the mutation and markers
	if(computeLDs==1 && G.getnumDisChr()!=0 )
	{
	   double* D_prime = new double[nmarkers];
	   G.linkagedis(realseqmatr, nmarkers, G.getnumNormChr(), G.getnumDisChr(), D_prime);	
	   oflds<<"<No"<<count<<">"<<endl;
	   for(int i=0; i<nmarkers; i++) oflds<<D_prime[i]<<"\t"; 
	   oflds<<"</No"<<count<<">"<<endl;
	   delete [] D_prime;
	}

	 //output to screen
	 cout<<"\n\nNo. "<<count<<endl;
	 if(datatype == GENOTYPE) 
	 {
	 	cout<<"The actual number of disease and normal chromosomes in the sample:\t";
		cout<<G.getnumDisChr()<<", "<<G.getnumNormChr()<<endl;
	 }
         cout<<"The time to the MRCA of the sample:\t"<<G.getTMRCA()<<endl;
         cout<<"The time to the MRCA of the sample of disease chromosomes:\t"<<G.getTMRCAdis()<<endl;
         cout<<"Number of recombinations occurred in the history of the sample:\t"<<G.getnumRecs()<<endl;
         cout<<"Number of recombinations occurred in the history of the disease sample:\t"<<G.getnumRecsDis()<<endl;
         cout<<"Number of mutations occurred in the history of the sample:\t"<<G.getnumMutations()<<endl;
         cout<<"Number of markers satisfied the polymorphism cutoff level:\t "<<nmarkers<<endl;
         cout<<"Current frequency of the disease allele:\t"<<G.currentDisFreq()<<endl;
	 //Output recombination rate
	if(printRecs==1)
	{
	   if(homorec==0)
 	   {
	      double* recarray = G.getnonhomoRecsArray();
	      int arraysize = G.getnumDiffRecRates();
	      if(useIceland==1)
	      {
		int* disarray = G.getvaryRec_position();
		cout<<"Icelandic recombination data: "<<endl;
		cout<<leftend<<" ~ "<<disarray[0]+leftend<<"\t"<<recarray[0]<<endl;
		for(int k=1; k<arraysize; k++)
		  cout<<disarray[k-1]+leftend<<" ~ "<<disarray[k]+leftend<<"\t"<<recarray[k]<<endl;
	      }
	      else 
	      {
		cout<<"Recombination rates along the interval (every kb) simulated by GBM"<<endl;
		for(int k=0; k<arraysize-1; k++) 
		  cout<<(double)k<<" ~ "<<(double)(k+1)<<"\t"<<recarray[k]<<endl;
	      }
	   }
	}

	//--------------------------------------------------------
        //---------------------Start to output--------------------
        ofs<<"<Num_"<<count<<">"<<endl;
        ofs<<"<num_loci>"<<nmarkers<<"</num_loci>"<<endl; //# markers
        ofs<<"<interval_size>"<<realmapdis[nmarkers-1]<<"</interval_size>"<<endl;
        if(datatype == HAPLOTYPE)
        {
            ofs<<"<haplotypes_normal>"<<endl;
            for(int x=0; x<numNormal; x++)
            {
               ofs<<"<n"<<x<<">";  for(int y=0; y<nmarkers; y++) {  ofs<<realseqmatr[x][y]<<" ";}
               ofs<<"</n"<<x<<">"<<endl;
            }
            ofs<<"</haplotypes_normal>"<<endl;
            ofs<<"<haplotypes_disease>"<<endl;
            int m=0;
            for(int x=numNormal; x<numNormal+numDis; x++)
           {
               ofs<<"<n"<<m<<">";
               for(int y=0; y<nmarkers; y++)  {ofs<<realseqmatr[x][y]<<" ";}
               ofs<<"</n"<<m<<">"<<endl;
               m++;
           }
           ofs<<"</haplotypes_disease>"<<endl;
        }
        else
        {
           int* genotypeDataNum=new int[(numDis+numNormal)*2];
           G.getGenotypeSample(genotypeDataNum, seedptr);

           //DD_normal, DN_normal, NN_normal
           ofs<<"<genotypes_normal>"<<endl;
           int m=0;
           for(int x=0; x<numNormal*2; )
           {
              ofs<<"<n"<<m<<"a>";
              for(int y=0; y<nmarkers; y++) {  ofs<<realseqmatr[genotypeDataNum[x]][y]<<" ";}
              ofs<<"</n"<<m<<"a>"<<endl;  x++;
              ofs<<"<n"<<m<<"b>";
              for(int y=0; y<nmarkers; y++) {  ofs<<realseqmatr[genotypeDataNum[x]][y]<<" ";}
              ofs<<"</n"<<m<<"b>"<<endl;  x++;
              m++;
           }
           ofs<<"</genotypes_normal>"<<endl;
           //DD_disease, DN_disease, NN_disease
	   ofs<<"<genotypes_disease>"<<endl;
           m=0;
           for(int x=numNormal*2; x<(numNormal+numDis)*2;)
          {
             ofs<<"<n"<<m<<"a>";
             for(int y=0; y<nmarkers; y++) {  ofs<<realseqmatr[genotypeDataNum[x]][y]<<" ";}
             ofs<<"</n"<<m<<"a>"<<endl; x++;
             ofs<<"<n"<<m<<"b>";
             for(int y=0; y<nmarkers; y++) {  ofs<<realseqmatr[genotypeDataNum[x]][y]<<" ";}
             ofs<<"</n"<<m<<"b>"<<endl; x++;
             m++;
          }
          ofs<<"</genotypes_disease>"<<endl;
          delete [] genotypeDataNum;
        }

        ofs<<"<phy_dis>";
        vector<double>::iterator ti;
        for(ti=realmapdis.begin(); ti!=realmapdis.end(); ti++)
        {    ofs<<(*ti)<<"\t"; }
        ofs<<"</phy_dis>"<<endl;
        ofs<<"<dis_frequency>"<<G.currentDisFreq()<<"</dis_frequency>"<<endl; //frequency of disease
        //population size at which the disease allele arose
	double foundingPop=N0*exp(-grate*mutage);
        ofs<<"<founding_popsize>"<<foundingPop<<"</founding_popsize>"<<endl;
        //ofs<<"<random_seed>"<<rand()<<"</random_seed>"<<endl;
        ofs<<"<TMRCA_diseaseTree>"<<G.getTMRCAdis()<<"</TMRCA_diseaseTree>"<<endl;
        ofs<<"<TMRCA_all>"<<G.getTMRCA()<<"</TMRCA_all>"<<endl;
        ofs<<"</Num_"<<count<<">"<<endl;
	//------------------finish output -----------------
	//-------------------------------------------------
	count++;
   }
   count--;
   
   end=clock();
   double elapsed = double(end-start);
   double secs = elapsed/CLOCKS_PER_SEC;

   cout<<endl<<"Summary (based on "<<count<<" replicates):"<<endl;
   cout<<"Average TMRCA:\t"<<aveTMRCA/((double)simuRep)<<endl;
   cout<<"Average TMRCA in disease tree:\t"<<aveDisTMRCA/(double)simuRep<<endl;
   cout<<"Average total branch lengths per genealogy:\t"<<totTime/(double)simuRep<<endl;
   cout<<"Average # mutations occurred per genealogy:\t"<<totMuts/(double)simuRep<<endl;
   cout<<"Average # recombinations per genealogy:\t"<<nrec/(double)simuRep<<endl;
   cout<<"Average # recombinations in disease tree:\t"<<(double)nrecDis/(double)simuRep<<endl;
   cout<<"Average # markers per genealogy:\t"<<totMarkers/(double)simuRep<<endl;
   cout<<"The proportion of rejected simulations is:\t"<<(double)numRejects/(double)(numRejects+count)<<endl;
   cout<<"Program running time (in seconds):\t"<<secs<<endl;
   cout<<endl<<"The minimum # markers among all simulation replicates:\t"<<miniNumMarkers<<endl;

   if(computeLDs==1)
   { oflds<<"</DATA>"<<endl;}	
 
   ofs<<"<Note>"<<endl;
   ofs<<"<total_num_genealogies>"<<count<<"</total_num_genealogies>"<<endl;
   ofs<<"<mean_recombinations>"<<(double)nrec/(double)count<<"</mean_recombinations>"<<endl;
   ofs<<"<running_time>"<<secs<<"</running_time>"<<endl;
   ofs<<"<minimum_nmarkers>"<<miniNumMarkers<<"</minimum_nmarkers>"<<endl;
   ofs<<"</Note>"<<endl;
   ofs<<"</DATA>"<<endl;
   ofs.close();

   delete seedptr;
   return 0;
}
