#include "Stats.h"

double ran1(long *idum)
{
    int j;
    long k;
    static long iy=0;
    static long iv[NTAB];
    double temp;
    if (*idum <= 0 || !iy)
    {                                // Initialize.
        if (-(*idum) < 1) *idum=1;   // Be sure to prevent idum = 0.
        else *idum = -(*idum);
        for (j=NTAB+7;j>=0;j--)
         {                           // Load the shuffle table (after warm-ups).
                k=(*idum)/IQ;
                *idum=IA*(*idum-k*IQ)-IR*k;
                if (*idum < 0) *idum += IM;
                if (j < NTAB) iv[j] = *idum;
        }
        iy=iv[0];
    }
    k=(*idum)/IQ;                       // Start here when not initializing.
    *idum=IA*(*idum-k*IQ)-IR*k;         // Compute idum=(IA*idum) % IM without
                                        // overflows by Schrage's methd.
    if (*idum < 0) *idum += IM;
    j=iy/NDIV;                          // Will be in the range 0..NTAB-1.
    iy=iv[j];                           // Output previously stored value and refill the shuffle table.
    iv[j] = *idum;
    if ((temp=AM*iy) > RNMX) return RNMX;  // Because users don't expect endpoint values.
        else return temp;
}

int random2(int top, long *seed)
{
  return (int)(floor((ran1(seed)*(double)top)));
}

double random3(double bound, long* seed)
{
    double tmp=ran1(seed)*bound;
    if(ran1(seed)<0.5) return -tmp;
    else return tmp;
}

//random integer between low, high boundaries
//possible return value (integer): [bot, top) 
int random4(int bot, int top, long *seed)  
{
  return (int)(floor((ran1(seed)*(double)(top-bot)))) + bot;
}


int poisson(double lamda, long* seedptr)
{
  double U=ran1(seedptr);
  int i=0; double p=exp(-lamda); double F=p;

  while(U>F)
  {
          p=lamda*p/(i+1); F=F+p;
          i++;
  }
 return i;
}

double approxNormal(double fre, double bound, double N, long* seedptr)
{
    double U=random3( bound, seedptr);
    fre= fre + U*pow((fre*(1-fre)/(2*N)),0.5);
    return fre;
}

int binomial(int N, double p, long* seedptr)
{
   if(p==1) return N;
   double U = ran1(seedptr);
   double c = p/(1-p); double pr = pow((1-p), N); double F = pr; 
   int i=0;	
   while(U>F)
   { pr = (c*(N-i)/(i+1))*pr; F+=pr; i++;}	
   return i;	 
}

void multinomial(int N, double* P, int nstates, long* seedptr,  int* result)
{
   int sum=0; 	
   for(int i=0; i<nstates-1; i++) 
   {
      result[i] = binomial(N-sum, P[i]*N/(N-sum), seedptr); sum+=result[i];
   }
   result[nstates-1] = N-sum; 
}

//generating standard normal distributed random variables N(0,1), using the Polar method
double stdnormal(long* seedptr)
{
  double S=2;  double U1, U2, v1, v2,x;
  while(S>1)
  {
     U1 = ran1(seedptr);  U2= ran1(seedptr);
     v1=2*U1-1;  v2=2*U2-1;  S= pow(v1, 2)+pow(v2,2);
  }
 x = sqrt(-2*log(S)/S)*v1;
 return x;
}

double uniform(double min, double max, long* seed)
{
  return ran1(seed)*(max-min)+min;
}

int poisson_normal(double lamda, long* seedptr)
{
    if(lamda<10) return poisson(lamda, seedptr);
    else return (int)(stdnormal(seedptr)*sqrt(lamda)+lamda);
}



double checkSamplePath(double N0, double grate, int disage, double sco, long* seedptr)
{
    int nfix=0; int nlost=0;

   for(int i=0; i<1000; )
   {
        double currentf = simfrevec(disage,  grate, N0, sco, seedptr);
        if(currentf==0) nlost++;
        else if(currentf==1) nfix++; 
        else i++;

        if( nlost+i ==1000 )
        {       
            double prop=(double)nlost/(double)(nlost+i);
            if(prop>0.9999)
                return prop;
        }
       if(nfix+i ==1000)
        {       
             double prop=(double)nfix/(double)(nfix+i);
             if(prop>0.9999) return prop;
        }
    }//for loop
    return 0;
}

double simfrevec(int ftime, double grate, double N0, double s, long* seedptr)
{
    double* frevec= new double[ftime+1];
    frevec[0] =0; 
 
    double num= 1;   //initially 1 copy of mutant allele
    double Nt= N0*exp(-ftime*grate);
    double fre= 1/(2*Nt);
    frevec[ftime]= fre;
 
    for(int gth=ftime-1; gth>=0; gth--)
    {
	Nt = N0*exp(-grate*gth);
	if(num<4)
	{
		double lamda;
		lamda = (fre + s*fre*(1-fre))*2*Nt;    
		num= poisson(lamda, seedptr);
		if(num<=0) {frevec[0]=0; break;}    
		fre= num/(2*Nt);
		if(fre>=1) {frevec[0]=1; break;}
	}
	else
	{
		double min = s*fre*(1-fre)-sqrt(3*fre*(1-fre)/(2*Nt));
		double max = s*fre*(1-fre)+sqrt(3*fre*(1-fre)/(2*Nt));
		double psv =  uniform(min, max, seedptr);
		fre = fre+psv;
		if(fre<=0) {frevec[0]=0; break;}
		if(fre>=1) {frevec[0]=1; break;}
		num= fre* 2* Nt;
		frevec[gth] = fre;
	}
    }
    double currentFreq =  frevec[0];
    delete [] frevec; 
    return currentFreq;
}

