/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#include <qmessagebox.h>
#include <qvalidator.h>
#include <qfile.h>
#include <qapplication.h>
#include <qprocess.h>
#include <qtimer.h>
#include <qstring.h>

#define MAPDISLIMIT 10
#define SNP 0
#define STRP 1
#define HAPLOTYPE 1
#define GENOTYPE 2
#include "Source/Stats.h"


void coalsimForm::helpContents()
{
      
    QString  home = QDir( "Doc/GeneArtisan_help.html" ).absPath();

    HelpWindow *help = new HelpWindow(home, ".", 0, "help viewer");
    help->setCaption("Coalsim - Help");
    
    help->setGeometry((int)(QApplication::desktop()->width() -
     (QApplication::desktop()->width() -
     (QApplication::desktop()->width() / 2)) * 1.68) / 2,
     (int)(QApplication::desktop()->height() -
     (QApplication::desktop()->height() -
     (QApplication::desktop()->height() / 2)) * 1.68) / 2,
     (int)((QApplication::desktop()->width() -
     (QApplication::desktop()->width() / 2)) * 1.35),
     (int)((QApplication::desktop()->height() -
     (QApplication::desktop()->height() / 2)) * 1.5));
     help->show();	

    /*if ( QApplication::desktop()->width() > 400
         && QApplication::desktop()->height() > 500 )
        help->show();
    else
        help->showMaximized();*/
}

void coalsimForm::showAbout()
{
    Aboutcoalsim* about = new Aboutcoalsim( this, "coalsim", TRUE );
    about->exec();
}

void coalsimForm::init()
{
    coalsimproc=NULL;
   
    numDis->setValidator(new QIntValidator(0, 100000, numDis));
    numNorm->setValidator(new QIntValidator(0, 100000, numNorm));
   
    fDD->setValidator(new QDoubleValidator(0, 1, 10, fDD));
    fDN->setValidator(new QDoubleValidator(0, 1, 10, fDN)); 
    fNN->setValidator(new QDoubleValidator(0, 1, 10, fNN));  
    
    popSize->setValidator(new QIntValidator(0, 100000000, popSize));
    growRate->setValidator(new QDoubleValidator(growRate));
    mutAge->setValidator(new QIntValidator(0, 100000000, mutAge));
    selectCo->setValidator(new QDoubleValidator(selectCo));
    lowfreq->setValidator(new QDoubleValidator(0, 1, 10, lowfreq));
    highfreq->setValidator(new QDoubleValidator(0, 1, 10, highfreq));
    
    intervSize->setValidator(new QDoubleValidator(0, 6, 10,intervSize));
    mutLoc->setValidator(new QDoubleValidator(mutLoc));
    
    mutRate_snp->setValidator(new QDoubleValidator(0.000000001, 0.0000001, 20, mutRate_snp));
    mutRate_strp->setValidator(new QDoubleValidator(0.0001, 0.01, 10, mutRate_strp));
    strpDensity->setValidator(new QDoubleValidator(0, 10000, 10, strpDensity));
    numMarker->setValidator(new QIntValidator(1, 100000, numMarker));
    alleFreq->setValidator(new QDoubleValidator(0, 1, 10, alleFreq));
    
    initRate->setValidator(new QDoubleValidator(0, 10, 10, initRate));
    driftGbm->setValidator(new QDoubleValidator(0, 0.00000001, 15, driftGbm));
    varGbm->setValidator(new QDoubleValidator(0, 0.00000001, 15,varGbm));
	iceFrom->setValidator(new QIntValidator( iceFrom));
    iceTo->setValidator(new QIntValidator(iceTo));
    
    numReps->setValidator(new QIntValidator(1, 100000000, numReps)); //must be greater than 0
    numMarkerD->setValidator(new QIntValidator(1, 100000, numMarkerD));
}


void coalsimForm::resetAll()
{
    statusBar()->message( "Reset simulation parameters",  2000 );
    
    //population data
    numDis->clear();
    numNorm->clear();
    dataType ->setCurrentItem(0);
	penetGroup->setEnabled(true);  
    fDD->clear(); fDD->setEnabled(true);
    fDN->clear(); fDN->setEnabled(true);
    fNN->clear(); fNN->setEnabled(true);
    
    //population demography
    popSize->clear(); 
    growRate->clear();
    mutAge->clear();
    selectCo->clear();
    showMean->clear(); 
    showVar->clear();
    lowfreq->setText(QString::number(0));
    highfreq->setText(QString::number(1));
    
    //genetic data
    snpORstrp->setCurrentPage(0);
    mutRate_defaut();
    strpdens_defaut();
    numMarker->clear();
    alleFreq->clear();
       
    //recombination model
    homoRec->setChecked(false);
    nonhomoRec->setChecked(false);
    gbmORiceland->setCurrentPage(0);
    chromNo->clear();
    range_region->clear();
    iceFrom->clear();
    iceTo->clear();
    gbm_defaut();
    printRecButton->setChecked(false);
    printRecButton->setEnabled(false);
    
    //output options
    DpCheck->setChecked(false);
    statfileName->clear();  
    statfileName->setEnabled(false); filenameLabel->setEnabled(false); statxmlLabel->setEnabled(false);
    fileName->clear();
    
    intervSize->clear();
    mutLoc->clear();
    numReps->clear();
    
    //output window
    output->clear();
    progressBar->reset();   
    
    //dmle input convertion
    dmlegroup->setEnabled(false);
    numMarkerD->clear();
    inputDName->clear();
    //refocus
    numDis->setFocus();
}


bool coalsimForm::checkDemogD()
{
    //check not empty
    if(popSize->text().isEmpty() || popSize->text().toLong()<=0)
    {    
		QMessageBox::information(this, tr("coalsim-Input validation"), 
		tr("The current population size should be greater than 0."));
		popSize->setFocus(); 
		return false;
	}
    if(growRate->text().isEmpty() || growRate->text().toDouble()<0)
    { 
		QMessageBox::information(this, tr("coalsim-Input validation"),
		tr("The population growth rate should be greater than or equal to 0."));
		growRate->setFocus();
		return false;
	}
    if(numDis->text().toInt()>0 && (mutAge->text().isEmpty() || mutAge->text().toInt()<=0) )
    { 
		QMessageBox::information(this, tr("coalsim-Input validation"),
		tr("The age of the disease muation should be greater than 0"));
		mutAge->setFocus(); 
		return false; 
	}
	if(numDis->text().toInt()>0 && selectCo->text().isEmpty())
    {
		QMessageBox::information(this, tr("coalsim-Input validation"),
		tr("You have not entered the selection coefficient yet.")); 
		selectCo->setFocus(); 
		return false;
	}
    
    double popsize = popSize->text().toDouble();
    double grate = growRate->text().toDouble();
    double age = mutAge->text().toDouble(); 
    //check accurate 
    if(numDis->text().toInt()>0)
    {
		double size = popsize*exp(-grate*age);
		if(size<2)
		{       
			QMessageBox::information(this, tr("coalsim-Input validation"), tr("The population size is ")
			+ QString::number(size)+tr(" at which the disease allele first arose.\n")+tr("It must be greater than 1.") );
			popSize->setFocus(); return false;
		}
    }
    return true; 
}

void coalsimForm::getExpectedFreq()
{
	showMean->clear(); showVar->clear();
    double checking = checkDemogD();
    if(!checking) return;
    
    time_t seed = time(NULL);
    srand((unsigned)seed);
    long* seedptr=new long;
    *seedptr= -1* rand();
    int iter=1000;
    double sum=0;
    double var[iter];
   
    double N0 = popSize->text().toDouble();
    double grate = growRate->text().toDouble();
    int disage =  mutAge->text().toInt();
    double sco = selectCo->text().toDouble();
    double* frevec=new double[disage+1]; 
	int nfix=0; int nlost=0;
	statusBar()->message( "Get expected frequency of the disease allele"); 

   for(int i=0; i<iter; )
   {
       double currentf = simfrevec(disage,  grate, N0, sco, seedptr);
	   if(currentf==0) nlost++;
	   else if(currentf==1) nfix++;
	   else
	   {
			sum += currentf;
			var[i] = currentf; i++;
		}
		if( nlost+i ==1000 )
		{
			double prop=(double)nlost/(double)(nlost+i);
			if(prop>0.9999)
			{
				QMessageBox::information(this, tr("coalsim-Input validation"), 
				tr("The proportion of the simulated population in which the disease allele was lost is ")
				+ QString::number(prop)+tr(" (>99.9%).\n")+tr("Please modify the parameters."));
				popSize->setFocus();
				statusBar()->message( "Simulation disease allele frequency abandoned", 2000 ); 
				return;
			}
		}
		if(nfix+i ==1000)
		{
			double prop=(double)nfix/(double)(nfix+i);
			if(prop>0.9999)
			{
				QMessageBox::information(this, tr("coalsim-Input validation"), 
				tr("The proportion of the simulated population in which the disease allele was fixed is")
				+ QString::number(prop)+tr(" (>99.9%).\n")+tr("Please modify the parameters."));
				popSize->setFocus();
				statusBar()->message( "Simulation disease allele frequency abandoned", 2000 ); 
				return;
			}
		}
   }
   
   double mean= sum/(double)iter;
   sum =0;
   for(int i=0; i<iter; i++)
       sum +=pow((var[i]-mean), 2);
   double variance= sum/(double)iter;
 
   showMean->setText(QString::number(mean));
   showVar->setText(QString::number(variance));
   
   delete [] frevec;
   delete seedptr;
}


double coalsimForm::simfrevec(int ftime, double grate, double N0, double s, long* seedptr)
{
    double* frevec= new double[ftime+1];
    frevec[0] =0; 
 
	double num= 1;   //initially 1 copy of mutant allele
	double Nt= N0*exp(-ftime*grate);
	double fre= 1/(2*Nt);
	frevec[ftime]= fre;
 
	for(int gth=ftime-1; gth>=0; gth--)
	{
		Nt = N0*exp(-grate*gth);
		if(num<4)
		{
			double lamda;
			lamda = (fre + s*fre*(1-fre))*2*Nt;    
			num= poisson(lamda, seedptr);
			if(num<=0) {frevec[0]=0; break;}    
			fre= num/(2*Nt);
			if(fre>=1) {frevec[0]=1; break;}
		}
		else
		{
			double min = s*fre*(1-fre)-sqrt(3*fre*(1-fre)/(2*Nt));
			double max = s*fre*(1-fre)+sqrt(3*fre*(1-fre)/(2*Nt));
			double psv =  uniform(min, max, seedptr);
			fre = fre+psv;
			if(fre<=0) {frevec[0]=0; break;}
			if(fre>=1) {frevec[0]=1; break;}
			num= fre* 2* Nt;
			frevec[gth] = fre;
		}
	}
	double currentFreq =  frevec[0];
    delete [] frevec; 
    return currentFreq;
}

bool coalsimForm::checkPopData()
{
	//# of disease
    if(numDis->text().isEmpty() || numDis->text().toInt()<0 )
    { 
		QMessageBox::information(this, tr("coalsim-Input validation"),
		tr("The number of cases in the sample must be greater than or equal to 0.")); 
		numDis->setFocus(); return false;
	} 
 
    //# of normal
    if(numNorm->text().isEmpty() || numNorm->text().toInt()<=0)
    { 
		QMessageBox::information(this, tr("coalsim-Input validation"),
		tr("The number of controls in the sample must be greater than 0.")); 
		numNorm->setFocus(); return false;
	}

    //penetrance parameters
    if( dataType-> currentItem() ==0 && numDis->text().toInt()>0)
	{
		if( fDD->text().isEmpty() || fDD->text().toDouble()<0 || fDD->text().toDouble()>1 
		||fDN->text().isEmpty() || fDN->text().toDouble()<0 || fDN->text().toDouble()>1 
		||fNN->text().isEmpty() || fNN->text().toDouble()<0 || fNN->text().toDouble()>1 )
		{  
			QMessageBox::information(this, tr("coalsim-Input validation"),
			tr("The Penetrance parameters should be between 0 and 1 inclusive.")); 
			fDD->setFocus(); return false;
		}
		if(fDD->text().toDouble()==0 && fDN->text().toDouble()==0 && fNN->text().toDouble()==0)
		{
			QMessageBox::information(this, tr("coalsim-Input validation"),
                        tr("There should be at least 1 penetrance parameter that is greater than 0."));
                        fDD->setFocus(); return false;
		}
	}
       
	return true;
}

bool coalsimForm::checkGenData()
{
    if( snpORstrp->currentPageIndex()==0 && (mutRate_snp->text().isEmpty()
	|| mutRate_snp->text().toDouble()<0.000000001 || mutRate_snp->text().toDouble()>0.000001 ))
	{  
		QMessageBox::information(this, tr("coalsim-Input validation"),
		tr("The mutation rate of SNPs should be between 10^(-9) and 10^(-6) inclusive.")); 
		mutRate_snp->setFocus(); return false;   
	}
    if(snpORstrp->currentPageIndex()==1 )
    {
		if (mutRate_strp->text().isEmpty() ||mutRate_strp->text().toDouble()<0.00001||mutRate_snp->text().toDouble()>0.01 )  
		{    
			QMessageBox::information(this, tr("coalsim-Input validation"),
			tr("The mutation rate of STRPs should be between 10^(-5) and 10^(-2) inclusive.")); 
			mutRate_strp->setFocus(); return false; 
		}
		if(strpDensity->text().isEmpty() || strpDensity->text().toDouble()<0 || strpDensity->text().toDouble()>1000)
		{ 
			QMessageBox::information(this, tr("coalsim-Input validation"),
			tr("STRP density should be between 0 and 1000.")); 
			strpDensity->setFocus(); return false;
		}     
    }
	if( numMarker->text().isEmpty() || numMarker->text().toInt()<=0 )
	{  
		QMessageBox::information(this, tr("coalsim-Input validation"),
		tr("The minimum number of markers should be greater than 0.")); 
		numMarker->setFocus(); return false; 
	}
	if( alleFreq->text().isEmpty() || alleFreq->text().toDouble()<0 || alleFreq->text().toDouble() >=1)
	{
		QMessageBox::information(this, tr("coalsim-Input validation"),
		tr("The markers cutoff level should be between 0 (inclusive) and 1 (exclusive). ")); 
		alleFreq->setFocus(); return false; 
	}
 
	return true;
}

bool coalsimForm::checkRecData()
{
	if( nonhomoRec->isChecked() )
	{
		if( gbmORiceland->currentPageIndex()==0 )  //use iceland data
		{
			if( chromNo->text().isEmpty() || chromNo->text().toInt()<1 || chromNo->text().toInt()>22)
			{ 
				QMessageBox::information(this, tr("coalsim-Input validation"), 
				tr("The chromosome number should be between 1 and 22, or chromosome X. "));   
				chromNo->setFocus(); return false;   
			}
			if( iceFrom->text().isEmpty() || iceTo->text().isEmpty())
			{
				QMessageBox::information(this, tr("coalsim-Input validation"), 
				tr("You have not entered the left and right boundaries of the chromosomal interval."));   
				iceFrom->setFocus(); return false;
			}
			else
			{
				QString range;
				getRangeofIceland(range);
    
				int pos=0;
				while((unsigned)pos<range.length())
				{ if(range.at(pos++).isSpace()) break; }
 
				long lefte = range.left(pos).stripWhiteSpace().toLong();
				long righte = range.right(range.length()-pos).stripWhiteSpace().toLong();
				if(iceFrom->text().toLong()<lefte || iceTo->text().toLong()>righte
				|| iceFrom->text().toLong() > iceTo->text().toLong())
				{
					QMessageBox::information(this, tr("coalsim-Input validation"), 
					tr("The chromosomal region should be within the total available region,\n")+
					tr("between ")+QString::number(lefte)+tr(" and ")+QString::number(righte)+ 
					tr(" for chromosome ")+chromNo->text()+tr("\n"));   
					iceFrom->setFocus(); return false;   
				}
			}
		}
		else   //simulate using GBM model
		{
			if( initRate->text().isEmpty() || initRate->text().toDouble()>4 || initRate->text().toDouble()<0 ) 
			{
				QMessageBox::information(this, tr("coalsim-Input validation"),
				tr("The initial recombination rate of GBM simulation should be between 0 and 4 inclusive.")); 
				initRate->setFocus(); return false;
			}
			if( driftGbm->text().isEmpty() ||driftGbm->text().toDouble()>0.0000001 ||
			varGbm->text().isEmpty() ||varGbm->text().toDouble()>0.0000001 ) 
			{
				QMessageBox::information(this, tr("coalsim-Input validation"),
				tr("The drift and variance parameters of GBM simulation should be less than 10^(-7) inclusive.")); 
				driftGbm->setFocus(); return false;
			}
		}
	}
	
	return true;
}

bool coalsimForm::checkInputAll()
{
 if(!checkPopData()) return false;
 if(!checkDemogD()) return false;
 
 if(numDis->text().toInt()>0 && (lowfreq->text().isEmpty() || lowfreq->text().toDouble()<0 ||
       highfreq->text().isEmpty() || highfreq->text().toDouble()>1 || lowfreq>=highfreq))
    { 
		QMessageBox::information(this, tr("coalsim-Input validation"),
		tr("The low, high boundaries of the current disease allele frequency should be between 0 and 1 inclusive.")); 
		lowfreq->setFocus(); return false; 
	}   

   if(!checkGenData()) return false;
   if(!checkRecData()) return false;
   
 //interval size
    if(intervSize->text().isEmpty() || intervSize->text().toDouble()<=0)
    { 
		QMessageBox::information(this, tr("coalsim-Input validation"),
		tr("The chromosomal interval size should be greater than 0.")); 
		intervSize->setFocus(); return false;
	}
	else
	{
		if(growRate->text().toDouble()<=0.005 && intervSize->text().toDouble()>0.5) //constant-size
		{
		   QMessageBox::information(this, tr("coalsim-Input validation"),
		   tr("The chromosomal interval size should be <= 0.5 Mb for a population with growth rate <= 0.005.")); 
		   intervSize->setFocus(); return false;
		}
		else if(growRate->text().toDouble()>0.005 && intervSize->text().toDouble()>4)
		{
		    QMessageBox::information(this, tr("coalsim-Input validation"),
		   tr("The chromosomal interval size should be <=4 Mb for a population with growth rate > 0.005.")); 
		   intervSize->setFocus(); return false;
		}
	}
 
    //mutation location
    if(numDis->text().toInt()>0 && (mutLoc->text().isEmpty() || mutLoc->text().toDouble()<0 
  || mutLoc->text().toDouble()>intervSize->text().toDouble()))
    { 
		QMessageBox::information(this, tr("GeneArtisan-Input validation"),
		tr("The disease mutation location should be within the chromosomal interval.")); 
		mutLoc->setFocus(); return false;
	}
    
    //# simulations
    if(numReps->text().isEmpty() || numReps->text().toInt()<=0 )
    { 
		QMessageBox::information(this, tr("GeneArtisan-Input validation"),
		tr("The number of simulation replicates should be greater than 0.")); 
		numReps->setFocus(); return false;
	}
    
     //LD file name
     if(DpCheck->isChecked() && statfileName->text().isEmpty())
    {  
		QMessageBox::information(this, tr("GeneArtisan-Input validation"),
        tr("You have not entered the file name for the results of pairwise LDs yet.")); 
		statfileName->setFocus(); return false;
    }
     
    //output file name
    if(fileName->text().isEmpty())
    { 
		QMessageBox::information(this, tr("GeneArtisan-Input validation"),
		tr("You have not entered the output file name yet.")); 
		fileName->setFocus(); return false;
	}
    
   return true;
}


void coalsimForm::activePenetData()
{
    if( dataType->currentItem() == 0 )
    { penetGroup->setEnabled(true);  }
    else{ penetGroup->setEnabled(false); fDD->clear(); fDN->clear(); fNN->clear(); }
}


void coalsimForm::deActiveDisease()
{
     if( !numDis->text().isEmpty() && numDis->text().toInt() ==0 )
    {
		dataType->setCurrentItem(1); dataType->setDisabled(true);  datatypeLabel->setDisabled(true);
		penetGroup->setEnabled(false);    
		fDD->clear(); fDN->clear(); fNN->clear(); 
  
		mutAge->clear(); mutAge->setEnabled(false);
		selectCo->clear(); selectCo->setDisabled(true);  selectcoLabel->setDisabled(true); 
		getFreq->setEnabled(false); ageLabel->setEnabled(false);
		showMean->setEnabled(false);  meanLabel->setEnabled(false);
		showVar->setEnabled(false); varLabel->setEnabled(false);
		showMean->clear(); showVar->clear();
		boundLabel->setEnabled(false); lowfreq->setEnabled(false); highfreq->setEnabled(false);
		andLabel->setEnabled(false); lowfreq->clear(); highfreq->clear();
                
		mutlocLabel->setEnabled(false); mutLoc->setEnabled(false); mutLoc->clear();
		DpCheck->setChecked(false); DpCheck->setEnabled(false); 
		filenameLabel->setEnabled(false);
		statfileName->clear();
		statfileName->setEnabled(false);
		statxmlLabel->setEnabled(false);
    }
    else
    {
  dataType->setEnabled(true);  datatypeLabel->setEnabled(true);
    
  mutAge->setEnabled(true); 
  selectcoLabel->setEnabled(true); selectCo->setEnabled(true);
  getFreq->setEnabled(true);  ageLabel->setEnabled(true);
  showMean->setEnabled(true);  meanLabel->setEnabled(true);
  showVar->setEnabled(true); varLabel->setEnabled(true); 
  boundLabel->setEnabled(true); lowfreq->setEnabled(true); highfreq->setEnabled(true);
  lowfreq->setText("0"); highfreq->setText("1");
  andLabel->setEnabled(true);
               
  mutlocLabel->setEnabled(true); mutLoc->setEnabled(true);
  DpCheck->setEnabled(true);  
    }
}

void coalsimForm::strpdens_defaut()
{
    if( numRepeat->currentItem()== 1 )  strpDensity->setText("11.8");
    else  strpDensity->setText("55.4");
}

void coalsimForm::mutRate_defaut()
{
    mutRate_strp->setText( "0.001" );
    numRepeat->setCurrentItem(0);
    strpDensity->setText("55.4");
    mutRate_snp->setText("0.000000001");
}

void coalsimForm::gbm_defaut()
{
    initRate->setText("1.19");
    driftGbm->setText("0.0000000307");
    varGbm->setText("0.0000000250");
}

void coalsimForm::runSimulation()
{
   output->clear();
   dmlegroup->setEnabled(false);
   progressBar->reset(); 

    //check if all inputs have been entered
    bool legal = checkInputAll();
    if(!legal) return;
	//check if the sample path of disease allele frequency can be approprately simulated
	legal = checkSamplePath();
	if(!legal) return;

    //collect input parameters and write to a file
    QFile paramfile("inputparams"); 
    if (!paramfile.open(IO_WriteOnly))
    {
		QMessageBox::critical( 0,
		tr("Fatal error"), tr("Could not open inputparams for writing."), tr("Quit") );
        exit( -1 );
     } 
    QTextStream paramf( &paramfile );
 
	char datatype;
	int numCases, numControls;  //sample size
	long N0; double grate; //current population size, population growth rate
	double sco; int mutage;
	double lowbound, highbound;
	double intervsize=0; //in Mb
	char markertype;
	double mu, mutloc, strpden=0;
	int homorec; int useIceland=0;
	double cutofflevel;
	int nmarker_limit;
	int simuRep;    
	double f_DD=0, f_DN=0, f_NN=0;
	int whichchrom=0; long leftend=0, rightend=0;
	double init_gbm=0, drift_gbm=0, var_gbm=0;

    //population data
    if( dataType->currentItem() == 0) datatype='g'; else datatype='h';
    paramf<<datatype<<endl;
    if( datatype == 'g')
    {   f_DD=fDD->text().toDouble(); 
        f_DN=fDN->text().toDouble();
        f_NN=fNN->text().toDouble();
        paramf<<f_DD<<endl<<f_DN<<endl<<f_NN<<endl;
     }
     numCases=numDis->text().toInt();
     numControls=numNorm->text().toInt();
     paramf<<numCases<<"\n"<<numControls<<endl;
    
     //population demography
     N0=popSize->text().toLong();
     grate=growRate->text().toDouble();
     if( numCases==0 ) mutage=-1; else  mutage=mutAge->text().toInt();
     sco=selectCo->text().toDouble();
     lowbound = lowfreq->text().toDouble();
     highbound = highfreq->text().toDouble();
     paramf<<N0<<"\n"<<grate<<"\n"<<mutage<<"\n"<<sco<<"\n"<<lowbound<<"\n"<<highbound<<"\n";
    
 //recombination model
    if( homoRec->isChecked() ) homorec=1; else homorec=0;
    paramf<<homorec<<endl;
    if(!homorec)
    {
		if(gbmORiceland->currentPageIndex()==0 )
		{
			useIceland=1;
			whichchrom = chromNo->text().toInt();
			leftend = iceFrom->text().toLong();
			rightend = iceTo->text().toLong();
			paramf<<useIceland<<"\n"<<whichchrom<<"\n"<<leftend<<"\n"<<rightend<<endl;
		}
		else 
		{
			useIceland=0;
			init_gbm = initRate->text().toDouble();
			drift_gbm = driftGbm->text().toDouble();
			var_gbm = varGbm->text().toDouble();
			paramf<<useIceland<<"\n"<<init_gbm<<"\n"<<drift_gbm<<"\n"<<var_gbm<<endl;
		}
	}
    intervsize = intervSize->text().toDouble(); 
	if(homorec==1 || (homorec==0 && useIceland==0)) paramf<<intervsize<<endl;
    mutloc = mutLoc->text().toDouble(); paramf<<mutloc<<endl;
    
    //genetci data 
    if( snpORstrp->currentPageIndex()==0 ) markertype='s';
    else markertype='m';
    paramf<<markertype<<endl;
    if(markertype =='s') 
    {  mu = mutRate_snp->text().toDouble(); paramf<<mu<<endl;}
    else {
        mu = mutRate_strp->text().toDouble(); paramf<<mu<<endl;
        strpden = strpDensity->text().toDouble(); paramf<<strpden<<endl;
    }
    
    cutofflevel=alleFreq->text().toDouble();
    nmarker_limit = numMarker->text().toInt();
    simuRep = numReps->text().toInt();
    paramf<<cutofflevel<<"\n"<<nmarker_limit<<"\n"<<simuRep<<endl;
    paramf<<fileName->text().stripWhiteSpace()<<endl;
	
	//print recombination data
	if(printRecButton->isChecked()) paramf<<1<<endl;
	else paramf<<0<<endl;
	
	//compute LDs
	if(DpCheck->isChecked())
	{ paramf<<1<<endl; paramf<<statfileName->text().stripWhiteSpace()<<endl;}
	else paramf<<0<<endl;
	paramfile.close();
    
    //set progress bar
	progressBar->setTotalSteps(numReps->text().toInt()*10);
	progressBar->setPercentageVisible( true );
	progressBar->setProgress(1);
 
     //output parameters to screen
     output->append("Parameters:\n");
     output->append("Sample size (cases, controls): \t"+QString::number(numCases)+", "
		+QString::number(numControls) +" \n");
     if( datatype=='h') output->append("Haplotype data \n");
     else { output->append("Genotype data, Penetrance parameters: \t "
		+QString::number(f_DD)+", "+QString::number(f_DN)+", "+QString::number(f_NN)+" \n"); }
     output->append("Population size: \t"+ QString::number(N0)+"\nPopulation growth rate:\t"+QString::number(grate)+" \n");
     if(numCases>0) 
	{
		output->append("Age of disease mutation: \t"+QString::number(mutage)+" \n");
		output->append("Selection coefficient: \t"+QString::number(sco)+" \n");
		output->append("Low, high boundaries of current disease allele frequency: \t"+
		QString::number(lowbound)+", "+QString::number(highbound)+" \n");
	}

	if(markertype=='s') output->append("SNP markers \n");
	else{ output->append("STRP markers, marker density: \t"+QString::number(strpden)+" \n"); }
	output->append("Marker mutation rate: \t" +QString::number(mu) +" \n");
	output->append("Minimum number of markers: \t"+QString::number(nmarker_limit)+" \n");
	output->append("Marker polymorphism cutoff level: \t"+QString::number(cutofflevel)+" \n");
      
    if(homorec){output->append("Homogeneous recombination rates \n");}
    else{
		if(!useIceland) { output->append("GBM recombination model: \n initial rate: \t"+QString::number(init_gbm)+" \n");
			output->append("drift parameter: \t"+QString::number(drift_gbm)+" \nvariance parameter: \t"+QString::number(var_gbm)+"\n");}
		else{ output->append("Using Icelandic recombination rates data: \n"); output->append("Chromosome:\t"+QString::number(whichchrom)+": "+ QString::number(leftend)+", "+QString::number(rightend) +"(bp)\n"); } 
	}
	output->append("Size of chromosomal interval: \t"+QString::number(intervsize)+" Mb \n");
	if(numCases>0) { output->append("Disease mutation location: \t"+QString::number(mutloc)+" Mb \n"); }
    output->append("Number of simulation replicates: \t"+QString::number(simuRep)+" \n");
    output->append("------------------------- \n \n");
 

	coalsimproc = new QProcess( this );
	if (coalsimproc==NULL )
	{
		QMessageBox::critical( 0,
		tr("Fatal error"), tr("Could not allocate memory for coalsimproc."), tr("Quit") );
        exit( -1 );
	}

	// Set up the command and arguments.
	coalsimproc->addArgument("./Exec/GeneArtisan"); 
	coalsimproc->addArgument("inputparams");

	//redirection output  
	connect( coalsimproc, SIGNAL(readyReadStdout()), this, SLOT(readFromStdout()) );
     
    //delete paramfile after finishing, and enable DMLE convert if applicable
	connect( coalsimproc, SIGNAL(processExited()), this, SLOT(finishRunning()) );
       
 abortButton->setEnabled(true); resetButton->setDisabled(true);
 runButton->setDisabled(true);
 statusBar()->message( "Running the simulation program"); 
 if ( !coalsimproc->start() )
 {
  QMessageBox::critical( 0,
  tr("Fatal error"), tr("Could not start running the GeneArtisan."), tr("Quit") );
        exit( -1 );
 }
}

void coalsimForm::readFromStdout()
{
 progressBar->setProgress( progressBar->progress() + 10 );
 // Read and process the data.
 output->append( coalsimproc->readStdout() );
}

void coalsimForm::finishRunning()
{
    abortButton->setDisabled(true);
    resetButton->setEnabled(true);
    runButton->setEnabled(true);
	
	QProcess* script = new QProcess(this);
	//rm -f inputparams
	script->addArgument("rm");
	script->addArgument("-f");
	script->addArgument("inputparams");
	script->start();
	delete script;
      
	//check if the simultaion program was terminated because the high rejection rate
	if(output->text().contains("terminated")!=0 || !coalsimproc->normalExit())
	{
		script = new QProcess(this);
		//rm simulation results file
		script->addArgument("rm");
		script->addArgument("-f");
		script->addArgument(fileName->text().stripWhiteSpace().append(".xml"));
		script->start();
		//rm LDs file
		script->clearArguments();
		script->addArgument("rm");
		script->addArgument("-f");
		script->addArgument(statfileName->text().stripWhiteSpace().append(".xml"));
		script->start();
		
		delete script;
		progressBar->reset();
		statusBar()->message( "Simulation terminated", 2000 );  
	        if(!coalsimproc->normalExit() && output->text().contains("aborted")==0) 
		  output->append("<font color=\"red\">Out of memory, the program was aborted without saving.</font>");
	}
	else 
	{
		QFile xmlfile;
		xmlfile.setName( fileName->text().stripWhiteSpace().append(".xml") );
		if(xmlfile.exists())
		{
			//obtain the minimum # markers among all simulation replicates
			int length = output->text().length();
			int i=1;
			while( output->text()[length-i] !=':') {i++;} i--;
			miniNumMarkers = output->text().right(i).toInt();

			statusBar()->message( "Finish running the simulation program", 2000 );
			progressBar->setProgress(numReps->text().toInt()*10 );
			output->append("Simulation results have been saved to the file: ");
			output->append(fileName->text().stripWhiteSpace().append(".xml"));
   
			if(DpCheck->isChecked())
			{
				QFile ldfile(statfileName->text().stripWhiteSpace().append(".xml"));
				if(ldfile.exists())
				{
					output->append("Pairwise LDs have been saved to the file: ");
					output->append(statfileName->text().stripWhiteSpace().append(".xml"));
				}
			}
			if(numDis->text().toInt()>0)
			{
				dmlegroup->setEnabled(true);
				dmlegrouplab->setEnabled(true);
				numMarkerD->setEnabled(true);
				inputDName->setEnabled(true);
				dmleConvert->setEnabled(true);
			}
		}
		
	}    
  if(coalsimproc!=NULL){ delete coalsimproc; coalsimproc=NULL; }
}


void coalsimForm::abortProgram()
{
    coalsimproc->kill();
    QTimer::singleShot( 5000, coalsimproc, SLOT( kill() ) );
	qApp->processEvents();
    output->append("\n\n");
    output->append("<font color=\"red\">The program was aborted without saving.</font>\n");
    progressBar->reset();
    statusBar()->message( "Simulation abandoned",  2000 );
    
	QProcess* script = new QProcess(this);
	//rm -f file.xml
	script->addArgument("rm");
	script->addArgument("-f");
	script->addArgument(fileName->text().stripWhiteSpace().append(".xml"));
	if(!script->start())
	{ 
		output->append("\n The file "); 
		output->append(fileName->text().stripWhiteSpace().append(".xml"));
		output->append( "can not be removed!"); 
	} 
	//rm LDs file
        script->clearArguments();
        script->addArgument("rm");
        script->addArgument("-f");
        script->addArgument(statfileName->text().stripWhiteSpace().append(".xml"));
        script->start();
	delete script;
}


void coalsimForm::disableStatFileName()
{
    if( DpCheck->isChecked())
    {  
		filenameLabel->setEnabled(true);  
		statfileName->setEnabled(true);  statxmlLabel->setEnabled(true);
	}
    if(!DpCheck->isChecked())
    {  
		filenameLabel->setEnabled(false); 
		statfileName->setEnabled(false); statxmlLabel->setEnabled(false);
		statfileName->clear();
	}
}


void coalsimForm::converttoDMLEinput()
{
    //check input 
    if(numMarkerD->text().isEmpty() || numMarkerD->text().toInt() > miniNumMarkers )
	{
		QMessageBox::information(this, tr("GeneArtisan-Input validation"),
		tr("The number of markers for the input files of DMLE must be less than\n")+
		tr("or equal to the minimum number of markers of all simulated data")); 
		numMarkerD->setFocus(); return;
	} 
    
    if(inputDName->text().isEmpty() )
 {
  QMessageBox::information(this, tr("GeneArtisan-Input validation"),
  tr("You have not entered the name of input files for DMLE yet.")); 
  inputDName->setFocus(); return; 
 }
 
 //convert to input files of DMLE
    bool success = convertInput();
 if(success)
 {
   statusBar()->message( "Simulation results converted", 2000 );
   output->append("Input files for DMLE have been written into the directory:\t");
   output->append(inputDName->text());  output->append("\n");
 }
}

//convert to input files for DMLE
bool coalsimForm::convertInput()
{
    int nm = numMarkerD->text().toInt();
    QProcess* script = new QProcess(this);

    //perl -w convert.pl test.xml DMLE 3 h filename
    script->addArgument("perl");
    script->addArgument("Exec/convert.pl");
    script->addArgument(fileName->text().stripWhiteSpace().append(".xml"));
    script->addArgument("DMLE"); script->addArgument(QString::number(nm));
    if( dataType->currentItem() ==0) script->addArgument("g");
    else script->addArgument("h");
    script->addArgument(inputDName->text());
    if ( !script->start() )
        {
                output->append("Error! Convertion did not complete." );
                return false;
        }
        delete script;
        return true;
}


void coalsimForm::exitProgram()
{
    if(coalsimproc!=NULL && coalsimproc->isRunning())  { abortProgram(); }
	this->close();
}

void coalsimForm::deactive_iceORgbm()
{
   if( homoRec->isChecked())  
   { 
		chromNo->clear(); range_region->clear(); iceFrom->clear(); iceTo->clear(); 
		gbmORiceland->setDisabled(true); 
		intervSize->clear(); intervSize->setEnabled(true);
		printRecButton->setDisabled(true);  printRecButton->setChecked(false);
	}
	if( nonhomoRec->isChecked())
	{
		gbmORiceland->setEnabled(true);
		deactive_intervSize();
		printRecButton->setEnabled(true);
	}
}

void coalsimForm::shwo_rangeofchrom()
{
    range_region->clear();
    //output the range of the chromosome
    if(!chromNo->text().isEmpty())
    {
		if(chromNo->text().toInt()<1 || chromNo->text().toInt()>22) {
		QMessageBox::information(this, tr("GeneArtisan-Input validation"),
		tr("The chromosome number must be between 1 and 22\n")); 
		chromNo->setFocus(); return;
		}
		else
		{
			QString range;
			getRangeofIceland(range);
   
			int pos=0;
			while((unsigned)pos<range.length())
			{ if(range.at(pos++).isSpace()) break; }
 
			int lefte = range.left(pos).toLong();
			int righte = range.right(range.length()-pos).toLong();
			range_region->setText(QString::number(lefte)+", "+QString::number(righte));
		}
	}
}





void coalsimForm::getRangeofIceland( QString & line)
{
	int whichchrom= chromNo->text().toInt();
	QString* mapfile = new QString("deCODEMap/MapChr");
	mapfile->append(QString::number(whichchrom));
		
	QFile mfile(*mapfile);
	if (!mfile.open(IO_ReadOnly))
	{
		QMessageBox::critical(this, "Error message",
					tr("The file (")+(*mapfile)+tr(") can not be opened for reading.\n"),
					QMessageBox::Ok, QMessageBox::NoButton);
		exit(-1);
	} 
	QTextStream stream( &mfile );
	line = stream.readLine();
	delete mapfile;
}


void coalsimForm::showIntervSize()
{
	if(!iceTo->text().isEmpty())
	{
		double intsize = (double)(iceTo->text().toLong()-iceFrom->text().toLong())/1000000; //in Mb
		intervSize->setText(QString::number(intsize));
	}
}


void coalsimForm::deactive_intervSize()
{
    if( gbmORiceland->currentPageIndex()==0  ) intervSize->setDisabled(true);
    else  {intervSize->setEnabled(true); intervSize->clear();}
}



bool coalsimForm::checkSamplePath()
{
    time_t seed = time(NULL);
    srand((unsigned)seed);
    long* seedptr=new long;
    *seedptr= -1* rand();
   
    double N0 = popSize->text().toDouble();
    double grate = growRate->text().toDouble();
    int disage =  mutAge->text().toInt();
    double sco = selectCo->text().toDouble();
   	int nfix=0; int nlost=0;
	

   for(int i=0; i<1000; )
   {
		double currentf = simfrevec(disage,  grate, N0, sco, seedptr);
		if(currentf==0) nlost++;
		else if(currentf==1) nfix++;
		else i++;
		
		if( nlost+i ==1000 )
		{
			double prop=(double)nlost/(double)(nlost+i);
			if(prop>0.9999)
			{
				QMessageBox::information(this, tr("GeneArtisan-Input validation"), 
				tr("The proportion of the loss of the disease allele is ")
				+ QString::number(prop)+tr(" (>0.9999).\n")+tr("Please modify the parameters."));
				popSize->setFocus();
				statusBar()->message( "Simulation disease allele frequency abandoned", 2000 ); 
				return false;
			}
		}
		if(nfix+i ==1000)
		{
			double prop=(double)nfix/(double)(nfix+i);
			if(prop>0.9999)
			{
				QMessageBox::information(this, tr("GeneArtisan-Input validation"), 
				tr("The proportion of the fixation of the disease allele is ")
				+ QString::number(prop)+tr(" (>0.9999).\n")+tr("Please modify the parameters."));
				popSize->setFocus();
				statusBar()->message( "Simulation disease allele frequency abandoned", 2000 ); 
				return false;
			}
		}
	}//for loop
	delete seedptr;
	return true;
}
