#include <iostream>
#include <fstream>
#include <vector>
#include <stdlib.h>
#include <algorithm>
#include <string.h>
#include <ctype.h>
#include <time.h>
using namespace std;
#include "Stats.h"

#define TIP -1 
#define RECDIS 0 
#define COALDIS 1
#define RECNORM 2
#define COALNORM 3
#define RECDD 4
#define RECDN 5  //current node is CASE
#define RECND 6  //current node is CONTROL
#define RECNN 7 

#define CASE 1
#define CONTROL 2

#define SNP 0
#define STRP 1

#define MAXALLE 1000   //maximum number of alleles at each marker locus
#define HAPLOTYPE 1
#define GENOTYPE 2

#define LEFT -1
#define RIGHT 1

typedef struct {
   double WTime;
   int Event;
}WTimeEvent;

typedef struct {
   double Posit;
   vector<double> Nmuts;   //# mutations at the position, and on which branches (U~[0,1])
}PositNmuts;

typedef struct{
   double key;
   int value;
}hash;

typedef struct{
   int id;
   double start;
   double end;
}hash2;

class Node
{
private:
  int ID;
  double WTime;
  int Event;
  int caseORcontrol;
  int* Sequ;
  double recBPoint;
  int passPart;
  
public:
  Node(int,double,int, int);
  ~Node();
  int getID(){return ID;}
  int getEvent(){return Event;}
  double getWTime(){ return WTime;}
  int isCaseORControl(){return caseORcontrol;}
  void setSequ(int*, int);
  int* getSequ(){ return Sequ;}
  void setRecBPoint( double bp){ recBPoint = bp; }
  double getRecBPoint(){return recBPoint;}
  void setpassPart(int x){ passPart=x;}
  int getpassPart() {return passPart;}
};

class Graph
{
  private:
     //Parameters input by user	 
     int dataType; //Genotype or haplotype
     int numDisIndiv, numNormIndiv; //number of disease and normal individuals	
     int numDis, numNormal;	//number of disease and normal chromosomes	  
     long N0; double grate, seleCo; 
     int disAge;
     double intervSize; int markerType;
     double Mu, strpDens, mutLoc; 
     int homoRec;  //if using homogeneous rec model(1/0)
     int usingIcelandRecs;   //check if using icelandic data
     double cutoffLevel; //marker cutoff level
     int numMarkerLimit; //number of markers limitation (the smallest # markers)
     int whichChrom; long leftEnd, rightEnd; //parameters for Iceland data
     double initRate, driftGBM, varGBM; //parameters for gbm 
     double fDD, fDN, fNN; //parameters for the penetrance model
     
     //internal data 
     int* num_geno_givenDis;  //number of sampled individuals with each genotypes, given disease phenotype
     int* num_geno_givenNorm;  //number of sampled individuals with each genotypes, given no phenotype
	
     double aveRecRate; //if using homogeneous recombination model, aveRecRate=intervSize/100,
                   //otherwise, it is the average of the recombination rates along the interval
     double* DisSamplePath;
     vector<Node*> NodesVector; //vector for storing all nodes
     vector<WTimeEvent*> WTimeEventVector; //vector for storing all waiting times and the associated events
     vector<int*> adjList;
     double TMRCA;  //TMRCA of the whole sample
     double TMRCAdis; //TMRCA of the disease sample
     double TotalTime; //sum of branch's length.
     int numNodes; //total number of nodes in the graph
     int numRecs; //total number of recombinations
     int numRecsDis; //total number of recombinations in disease tree
     int numRecsDwN; //total number of events that disease recombined with normal
     int numMutations; //total number of mutations occurred in the history of the sample 
     int numMutLoci; //number of loci that one or more mutations have been occurred in the genealogy
     PositNmuts** MapDis;
     double* MarkerPosit;
     int* varyRec_position;  //used for storing positions of markers with respectvie to 
     			    //the left end of the interval, when using Icelandic data
     int numDiffRecRates; //number of different recombination rates along the interval
     double* nonhomoRecsArray; 
     double* recRatesCDF;
     int** SampleSeqMatrix;
     int** RealSampleSeqMatr;  //Sample sequences after cutoff
     vector<double> RealMarkerPosit; //Marker positions after cutoff
     int RealNumMarkers; //# markers after cutoff

     //---added on May 5-----
     vector<hash*> markMasac; //marker each sub-region
     vector<Node*> mrcaNodes; //all of the MRCA nodes for each segment of chromsomes

  public:
     Graph(int, int, int, long, double, double, int, double, int, double, double, double, int, int,double, int);
     ~Graph();
     void setIcelandParams(int, long, long);
     void setGBMParams(double, double, double);
     void setPenetrParams(double, double, double);
     void simuSamplePath(double, double, long*);
     void createTipNodes();
     void simuWaitTime(long*);
     double coaltimeDiscrete(double, int, int, long*);
     bool simuGenealogy(double, double, long*);
     void chooseDescen(Node*, vector<int>&, vector<int>&, long*);
     bool addMutations(long*);
     void forwardTraversal(long*);
     void mutSequency(int*, double, double, long*);
     int ranchar(long*);
     int ranchar2(int, long*);
     double getTMRCA(){ return TMRCA;}
     double getTMRCAdis(){ return TMRCAdis;}
     double getTotalTime(){ return TotalTime;}
     int getnumRecs(){ return numRecs;}
     int getnumRecsDis(){ return numRecsDis;}
     int getnumRecsDwN(){return numRecsDwN;}
     int getnumMutations(){ return numMutations;}	
     int getnumMutLoci(){ return numMutLoci;}
     int getnumMarkers(){ return RealNumMarkers;}
     vector<double>& getRealMarkerPosit(){return RealMarkerPosit;}
     int** getRealSampleSeqMatr(){return RealSampleSeqMatr;}
     int getnumDisChr(){ return numDis;}
     int getnumNormChr(){return numNormal;}
     int getnumDiffRecRates(){return numDiffRecRates;}	
     int* getvaryRec_position() {return varyRec_position;}	
     double* getnonhomoRecsArray() {return nonhomoRecsArray;}	
     void printGraph();
     double chooseBreakpoint(long*);
     void simuRecGBM(double, double, double, double, long*);
     void getIcelandicRecs(int, long, long);
     void codingSampleSeqs();
     int transform(int[], int);
     int MarkersCutoff();
     double currentDisFreq(){ if(DisSamplePath==NULL) return 0; return DisSamplePath[0];}
     void penetrance(long*);
     void getGenotypeSample(int*, long*);
     void ranOrder(int*, long*);
     void linkagedis(int**, int , int, int , double*);	
     int setuppassPart(Node*, Node*, long*);
     bool checkMasacMRCA(Node*);
     bool getOverlapRegion(vector<hash2*>&);
     bool checkAllTips(vector<hash2*>); 
     void clearVector(vector<hash2*>&);
     void copyVector(vector<hash2*>&, vector<hash2*>&);
     void combineAdjCells(vector<hash2*>&);
     bool checkValid();
     bool inSamllInterv(double);
};
