#include"greg.h"
#include"lexicon.h"
// #include"setdata.h"
#define CPLUS
#define CHARLIE

// using namespace std;

gdata genosample[MAXINDS];      // name and number of individual data
gdata genochange[MAXINDS];     // gdata including changed M, t 
long numinds,numpops,numloci;   // actual number of individuals, pops, loci
long numalleles[MAXLOC];     // number of alleles at each locus
long numallelesold[MAXLOC];    // number of alleles before elimination of monos
long allnames[MAXLOC][MAXALLELE];    // corresponding number of each allele name
long newallcheck;    // a check value to determine if the allele name is new
long numdivsp;    // the number of divisions for the allele frequency histogram
long numdivsm;    // the number of divisions for the migration rates histogram
long numdivsF;    // the number of divisions for the inbreeding histogram
double migmat[MAXPOPS][MAXPOPS];   // migration rates between populations
double cmigmat[MAXPOPS][MAXPOPS];  // changed migration rates
double nextm[MAXPOPS][MAXPOPS];    // alternative values for migmat
double pmat[MAXPOPS][MAXLOC][MAXALLELE];    // allele frequencies
double nextp[MAXPOPS][MAXLOC][MAXALLELE];   // alternative allele frequencies
double Fvalue[MAXPOPS];     // F (inbreeding) value within populations
double Fnew[MAXPOPS];     // proposed new F values
double Finit;      // initial value of F in the populations
double initmii = 0.85;   // the initial value of mii
long allfreqhis[MAXPOPS][MAXLOC][MAXALLELE][MAXDIVSP];  // frequencies of the allele frequencies
long Ffreqhis[MAXPOPS][MAXDIVSF];      // frequencies of the inbreeding values
long mfreqhis[MAXPOPS][MAXPOPS][MAXDIVSM];   // frequencies of m frequencies
long rvxhist[MAXDIVSP];      // test the distribution of rvx
double likgenold;        // the loglikgeno for the current state
double likgennew;        // the loglikgeno for the proposed state
double likgenoldslow;   // the slow version of likgenold
double likgennewslow;   // the slow version of likgennew
double likmtold;         // the loglikmt for the current state
double likmtnew;         // the loglikmt for the proposed state
double likmtoldslow;    // the slow version of likmtold
double likmtnewslow;       // the slow version of likmtold
double likmtlarge = 0;   // likmt to check against for likelihood printouts
double likgenolarge = 0;  // likgeno to check against for likelihood printouts
double meannew[MAXPOPS][MAXLOC][MAXALLELE];  // the mean allele frequency
double meanold[MAXPOPS][MAXLOC][MAXALLELE];  // old mean allele frequency
double meannewF[MAXPOPS];     // the mean F value
double meanoldF[MAXPOPS];     // old mean F value
double meannewm[MAXPOPS][MAXPOPS];   // the mean migration frequency
double meanoldm[MAXPOPS][MAXPOPS];   // old mean migration frequency
double varnew[MAXPOPS][MAXLOC][MAXALLELE];     // variance for allele frequency
double varold[MAXPOPS][MAXLOC][MAXALLELE];   //  old variance for allele freq
double varnewF[MAXPOPS];        // variance for F value
double varoldF[MAXPOPS];       // old variance for F value
double varnewm[MAXPOPS][MAXPOPS];    // variance of migration frequency
double varoldm[MAXPOPS][MAXPOPS];     // old variance for allele frequency
long anchist[MAXINDS][MAXPOPS][MAXANC];    // frequency of ancestry assignments
long pophist[MAXPOPS][MAXPOPS][MAXANC];    // freq of anc assignments per pop
long pophists[MAXPOPS][MAXPOPS][MAXANC];  // freq of anc samples/pop/iteration
long pophistc[MAXPOPS][MAXPOPS][MAXANC];  // freq of anc change/pop/iteration
long pophistage[MAXPOPS][MAXANC];     //freq of age classes in each pop
long counter;                // a counter
double tryvar;             // just a practice variable, to be removed later
long i,j,k,m,r,s,w;	    // Greg had no initial value for p. was causing trouble. Bruce added p=0
long a, b;                  // used for setting intial migration rates 
long agecount[MAXANC];     // counts the number of times each age is generated
long idum=-10;
long q;          // just a variable used in the made-up data
long numits = 3000000;    // the number of iterations the program will run for
long anc;     // the number of ancestral states
long anccount[MAXANC];    // number of times each ancestral state is chosen
long ancaccept[MAXANC];   // number of times each state is accepted
long changecount;         // the number of times a change in state occurs
double summs;         // the sum of m for states 1, 2
double sumcheck;    // check to see why randomly assigned pmat isn't working
double rvx;     // a random variable
long cpop, cloc, callele;     // the potential pop, loc, and allele to change
long cpopb;                   // the other population to change
long cind;         // the potential individual to change
long numcind[MAXINDS];       // the number of times each individual was chosen
long numcpop[MAXPOPS];     // the number of times each population was chosen
long pop2change;     // part of the loop to change the proposed population
long checkchange;      // the number of times that sample != change
long numchange;     // the number of individuals to change each iteration
double deltap;        // the amount p can be changed by
double deltaminit;          // the amount m can be changed by
double deltam;
double deltai;        // the probability of changing each individual i
double deltaF;        // the amount F can be changed by
double modp;          // the amount p will be changed by
double modm;         // the amount m will be changed by
double modF;        // the amount F will be changed by
double sumallfreq;      // the sum of allele frequencies but i at a locus
double sumalleles;    // a test variable to make sure that alleles sum to 1
double sumallelesold;  //
double summ;          // sum of all m values for a population
double summadj;       // sum of all migration rates but i in a population
double maxminit;    // maximum initial value of m, for all foreign pops
double alpha;   // the value that determines if we accept the altered values
double bounda, boundb;   // the bounds of values for the histogram
double maxlog, minlog;    // the largest and smallest value that loglikmt takes
char *missing1 = "000";
char *missing2 = "00";
char *missing3 = "0";
long indmissing[MAXINDS];  // keep track of which individuals have missing data
long datagone[MAXINDS][MAXLOC];   // which loci are missing
long missingdata = 0;     // number of holes in data
long cmissingdata;    // missing data to change
long mcounter = 0;    // a counter used for missing data
float likdataadj;   // adjustment for the prob of going from het to hom
long indallhist[MAXINDS][MAXLOC][MAXALLELE];    // Number of times each allele state occurs for missing individuals
double indllgenold[MAXINDS][MAXLOC];       // the loglikgeno value for each individual at each locus
double indllgennew[MAXINDS][MAXLOC];       // new loglikgeno individual values
long pchange = 0;      // count the number of times allele frequency changes
long pchange2[MAXLOC];    // the number of times an allele changes at each locus
long Fchange = 0;      // count the number of times F changes
long mchange = 0;     // count the number of times migmat changes
long prob0 = 0;     // the number of times individuals in a pop are source
long prob1 = 0;   // the number of times individuals in a pop are migrants
long prob2 = 0;   // the number of times individuals in a pop are hybrids
long popsums[MAXPOPS];    // the number of individuals occuring in each population
double gampopsum = 0;     // the gamma values of popsums summed
double adjconst = 0;     // the constant used to adjust m's to sum to 1
char ofile[MAXLENGTH];
int largest;    // the division of numdivsm that contains the most values
int mode[MAXPOPS][MAXPOPS];        // the mode of the m values
double nmode;         // the true mode of m values
long newLname[MAXPOPS];     // new pop names if a locus is monomorphic
long Lmonomorphic[MAXLOC];   // monomorphic state of each locus
long numlocold;    // old number of loci before eliminating monomorphic ones
double allelesizemin;    // smallest allele frequency
double migsizemin;      // smallest migration rate
double migsizemax;      // largest migration rate
double allelesizemax;
bool done = false;   // the boolean variable that controls the loop for entering user options
int option1;   // the user's choice for the first set of options
int option2;   // the user's choice for the second set of options
long sampfreq = 2000;   // the frequency with which the MCMC is sampled
long burnin = 999999;   // the length of the burn-in, or number of iterations before data collection begins
char line[100];    // line of input
int deltapinput = 15;   // inputted values for these variables
int deltaminput = 15;
int deltaFinput = 15;
double minfreq = 0.0;   // minimum frequency for values
long numberchi[MAXPOPS][4];    // the number of times values fall into each group for the chi-squared test to determine if final non-migration rates differ from the prior
double freqchi[MAXPOPS][4];   // the frequency values fall into each group
double totnumberchi;   // the total number of times values are examined
double chivalue[MAXPOPS];   // the chi-squared value for the likelihood ratio test
int histprior;   // the histogram section that the non-migration rate falls into 
long counterliks = 0;     // the counter for the number of likelihoods collected
long numpassthrough = 0;  // the number of times the likelihood arrays are cycled through
long numpasses;  // the number of array values examined for the histogram
double loglikmt4hist[2001];   // an array of likmt values
double loglikgeno4hist[2001];   // an array of likgeno values
long likgenohist[21];    // the histogram for likgeno values
long likmthist[21];     // the histogram for likmt values
double loglikmtmin;    // minimum likmtvalue
double loglikgenomin;  // minimum likgeno value
double loglikmtmax;   // maximum mt value
double loglikgenomax;  // maximum geno value

// The following variables determine the output saved.  Set to '1' if the information is desired, and any other integer otherwise.

int settings = 1;    // Initial user settings
int pdata = 1;      // data provided in the input file
int allelepost = 1;  // posterior probabilities of the allele frequencies
int Fpost = 1;   // posterior probabilities of the F vlaues
int assign = 1;   // individual assignments
int mdatapost = 1;  // posterior genotype probabilities at each locus missing data.  Note, this will only print if 'assign' is 1
int popassign = 0;  // The number of times each individual is assigned to ancestral states, summed over populations
int migpost = 1;   // posterior probabilities of migration rates
int nchanges = 1;   // The number of times each proposed change is accepted.
int Fafinal = 0;   // displays the histograms for each of the frequencies
int Llvaluesrun = 0;  // log likelihood values throughout the run
int Llvaluessum = 1;  // summary of the log likelihood values when the chain is sampled
int chi2print = 0;  // the likelihood ratio test of the prior vx. posterior distribution of allele frequencies

/********************************************************
 *  BayesAss.cpp -- This program will calculate values  *
 *   of M, t, m and p using McMC for an inputted number *
 *   of individuals.                                    *
 *                                                      *
 *  Functions:                                          *
 *   loglikmt -- calculates Pr values for M, t for a    *
 *    certain value of m.                               *
 *   loglikgeno -- calculates Pr values of the          *
 *    genotypes given M, t, p, s                        *
 *   logMadj -- Metropolis-hastings adjustment for the  *
 *    assymetry of some of the state changes for        *
 *    immigrant ancestry and time                       *
 *   gammln -- calculates the gamma distribution        *
 *   ran1 -- this function uses ran1 to generate all    *
 *    random values                                     *
 *                                                      *
 *  Note: this program makes use of the Hastings-       *
 *   Metropolis algorithm.                              *
 *                                                      *
 *  The difference between greg2 and greg3 is that      *
 *   greg3 picks immage first while greg2 picks immanc  *
 *   first and therefore needs logprMadj.               *
 *                                                      *
 *  greg5 attempts to add lexicon to greg3 so that      *
 *   user data can be taken in to the program           *
 *                                                      *
 *  There is a problem with nan errors in previous      *
 *    gregs that has been fixed in this one.            *
 *    These errors occurred during the calculation of   *
 *    cmigmat.                                          *
 ********************************************************/



/********************************************************
 *  function loglikmt                                   *
 *   calculate log Pr(M, t | m)                         *
 ********************************************************/

double loglikmt(long anc, long numinds, long numpops, gdata genosample[MAXINDS],
		double migmat[MAXPOPS][MAXPOPS], double gampopsum)
{
  long immcounts[3][MAXPOPS][MAXPOPS];     // the 3 is for the age of immigrant       ancestry that we will consider (t)
  long i,j,t,h;
  long popsums[MAXPOPS];
  double loglik=0.0;

  for(t=0;t<=2;t++)
    for(i=1;i<=numpops;i++)
      for(j=1;j<=numpops;j++)
	{
	  immcounts[t][i][j]=0;
	}
  for (j=1; j<=numpops; ++j)
    popsums[j] = 0;
  for(t=0;t<=2;t++)                    // go through all individuals and 
    for(i=1;i<=numpops;i++)            // adds 1 to whichever category of 
      for(j=1;j<=numpops;j++)          // (source)(ancestry)(age) it falls
        {                              // into i.e. Nijt
          for(h=1;h<=numinds;h++)
            if((genosample[h].immanc==i)&&(genosample[h].srcpop==j)&&(genosample[h].immage==t))
              immcounts[t][i][j]+=1; 
        }
  //  for (t=0; t<=2; ++t)
  //  for (i=1; i<=numpops; ++i)
  //    for (j=1; j<=numpops; ++j)
  //	popsums[j] += immcounts[t][i][j];
  //  for (j=1; j<=numpops; ++j)
  //   loglik += gammln((float)popsums[j] + 1.0);
  //  loglik+=gammln((float)numinds+1.0);        // gamma(n+1)

  // examplefile << "loglik has a value of " << loglik << " after counts" << '\n';
    //  immcounts[0][1][1] = 10;          //TRY
    // immcounts[1][2][1] = 3;           //TRY
    // immcounts[2][2][1] = 4;           //TRY
    // loglik+=gammln(18.0);               //TRY

  loglik = gampopsum;
  for(t=1;t<=2;t++)
    for(i=1;i<=numpops;i++)
      for(j=1;j<=numpops;j++)
	{
	  if(i!=j)              // add Nijt * log(t*mij) - log gamma(nijt+1)
	    {
	      loglik+=(float)immcounts[t][i][j]*log((double)t*migmat[i][j])-                  gammln((float)immcounts[t][i][j]+1.0);
	    }
	}
  //  examplefile << "loglik is now " << loglik << '\n';
  for(i=1;i<=numpops;i++)      // add Niio * log(mii) - log gamma(niio + 1)
    {
      summs = 0.0;
      for (j=1; j<=numpops; ++j)       // allow for other generations
	{
	  if (i != j)
	    for (t=1; t<anc; ++t)
	      summs += pow(2, t-1) * migmat[j][i];
	}
      loglik += (float)immcounts[0][i][i] * log(1.0 - summs) -                        gammln((float)immcounts[0][i][i] + 1.0);
      //  examplefile << "summs has a value of " << summs << '\n';
      //   examplefile << "loglik is now " << loglik << '\n';
    }
  // examplefile.close();
  return(loglik);
}

/*********************************************************
 *  function loglikmtslow                                *
 *   calculate log Pr(M, t | m)                          *
 *********************************************************/

double loglikmtslow(long anc, long numinds,long numpops,gdata genosample[MAXINDS],
		double migmat[MAXPOPS][MAXPOPS])
{
  long immcounts[3][MAXPOPS][MAXPOPS];     // the 3 is for the age of immigrant       ancestry that we will consider (t)
  long i,j,t,h;
  long popsums[MAXPOPS];
  double loglik=0.0;

  // initialize matrix to 0's

  // ofstream examplefile ("output2.txt");
  //  for (i=1; i<=numpops; ++i)
  //  for (j=1; j<=numpops; ++j)
  //     examplefile << "migmat[" << j << "][" << i << "] is " << migmat[j][i] << '\n';
  //     examplefile << "anc is " << anc << ", numinds is " << numinds << " and numpops is " << numpops << '\n' << '\n';
  // for (i=1; i<=numinds; ++i)
  //  {
  //    examplefile << "individual " << i << "'s genosample srcpop, immanc, ammage are " << genosample[i].srcpop << ", " << genosample[i].immanc << " and " << genosample[i].immage << '\n';
  //    examplefile << "genotype is " << genosample[i].genotype[1][0] << ", " << genosample[i].genotype[1][1] << '\n' << '\n';
  //    }   
  for(t=0;t<=2;t++)
    for(i=1;i<=numpops;i++)
      for(j=1;j<=numpops;j++)
	{
	  immcounts[t][i][j]=0;
	}
  for (j=1; j<=numpops; ++j)
    popsums[j] = 0;
  for(t=0;t<=2;t++)                    // go through all individuals and 
    for(i=1;i<=numpops;i++)            // adds 1 to whichever category of 
      for(j=1;j<=numpops;j++)          // (source)(ancestry)(age) it falls
        {                              // into i.e. Nijt
          for(h=1;h<=numinds;h++)
            if((genosample[h].immanc==i)&&(genosample[h].srcpop==j)&&(genosample[h].immage==t))
              immcounts[t][i][j]+=1; 
        }
  for (t=0; t<=2; ++t)
    for (i=1; i<=numpops; ++i)
      for (j=1; j<=numpops; ++j)
	popsums[j] += immcounts[t][i][j];
  for (j=1; j<=numpops; ++j)
    loglik += gammln((float)popsums[j] + 1.0);
  //  loglik+=gammln((float)numinds+1.0);        // gamma(n+1)
  // examplefile << "loglik has a value of " << loglik << " after counts" << '\n';
    //  immcounts[0][1][1] = 10;          //TRY
    // immcounts[1][2][1] = 3;           //TRY
    // immcounts[2][2][1] = 4;           //TRY
    // loglik+=gammln(18.0);               //TRY

  for(t=1;t<=2;t++)
    for(i=1;i<=numpops;i++)
      for(j=1;j<=numpops;j++)
	{
	  if(i!=j)              // add Nijt * log(t*mij) - log gamma(nijt+1)
	    {
	      loglik+=(float)immcounts[t][i][j]*log((double)t*migmat[i][j])-                  gammln((float)immcounts[t][i][j]+1.0);
	    }
	}
  //  examplefile << "loglik is now " << loglik << '\n';
  for(i=1;i<=numpops;i++)      // add Niio * log(mii) - log gamma(niio + 1)
    {
      summs = 0.0;
      for (j=1; j<=numpops; ++j)       // allow for other generations
	{
	  if (i != j)
	    for (t=1; t<anc; ++t)
	      summs += pow(2, t-1) * migmat[j][i];
	}
      loglik += (float)immcounts[0][i][i] * log(1.0 - summs) -                        gammln((float)immcounts[0][i][i] + 1.0);
      //  examplefile << "summs has a value of " << summs << '\n';
      //   examplefile << "loglik is now " << loglik << '\n';
    }
  // examplefile.close();
  return(loglik);
}


/***************************************************
 *   Function loglikgeno                           *
 *    calculate log Pr(X | M, t, p, s)             *
 ***************************************************/

double loglikgeno(long numinds,long numpops,long numloci,gdata genosample[MAXINDS], double migmat[MAXPOPS][MAXPOPS],double pmat[MAXPOPS][MAXLOC][MAXALLELE], double Fvalue[MAXPOPS])
{
  long h,k,j;
  double loglik=0.0;

  for(h=1;h<=numinds;h++)        // individuals
    for(k=1;k<=numloci;k++)      // loci
      for(j=1;j<=numpops;j++)    // populations
	{
	  if((genosample[h].immanc==genosample[h].srcpop)&&(genosample[h].srcpop==j))            // if immigrant ancestry = sourcepop = j
	    {
	      if(genosample[h].genotype[k][0]==genosample[h].genotype[k][1])
		loglik += log(((1.0 - Fvalue[j]) * pow(pmat[j][k][genosample[h].genotype[k][0]], 2.0)) + (Fvalue[j] * pmat[j][k][genosample[h].genotype[k][0]]));
	      // loglik += log(((1.0 - Fvalue[j]) * pow(pmat[j][k][genosample[h].genotype[k][0]], 2.0)) + (Fvalue[j] * pmat[j][k][genosample[h].genotype[k][0]]));
	            else
		loglik += log(2.0) + log(pmat[j][k][genosample[h].genotype[k][0]]) + log(pmat[j][k][genosample[h].genotype[k][1]]) + log(1.0 - Fvalue[j]);
	      // loglik += (2.0) + (pmat[j][k][genosample[h].genotype[k][0]]) + (pmat[j][k][genosample[h].genotype[k][1]]) + (1.0 - Fvalue[j]);
	    }
	  else
	    if((genosample[h].immanc==j)&&(genosample[h].immage==1)) // t=1
	      if(genosample[h].genotype[k][0]==genosample[h].genotype[k][1])
		loglik += log(((1.0 - Fvalue[j]) * pow(pmat[j][k][genosample[h].genotype[k][0]], 2.0)) + (Fvalue[j] * pmat[j][k][genosample[h].genotype[k][0]]));
	  // loglik += (((1.0 - Fvalue[j]) * pow(pmat[j][k][genosample[h].genotype[k][0]], 2.0)) + (Fvalue[j] * pmat[j][k][genosample[h].genotype[k][0]]));
	      else
		loglik += log(2.0) + log(pmat[j][k][genosample[h].genotype[k][0]]) + log(pmat[j][k][genosample[h].genotype[k][1]]) + log(1.0 - Fvalue[j]);
	  // loglik += (2.0) + (pmat[j][k][genosample[h].genotype[k][0]]) + (pmat[j][k][genosample[h].genotype[k][1]]) + (1.0 - Fvalue[j]);
	    else
	      if((genosample[h].immanc==j)&&(genosample[h].immage>1)) // t>1
		if(genosample[h].genotype[k][0]==genosample[h].genotype[k][1])
		  loglik+=log((1.0-1.0/pow(2.0,(double)genosample[h].immage-                     2.0))*pmat[genosample[h].srcpop][k][genosample[h].genotype[k]                  [0]]*pmat[genosample[h].srcpop][k][genosample[h].genotype[k]                   [0]]+(1.0/pow(2.0,(double)genosample[h].immage-2.0))*                      pmat[j][k][genosample[h].genotype[k][0]]*                                      pmat[genosample[h].srcpop][k][genosample[h].genotype[k][0]]);
	  // loglik+=log((1.0-1.0/pow(2.0,(double)genosample[h].immage-                     2.0))*pmat[genosample[h].srcpop][k][genosample[h].genotype[k]                  [0]]*pmat[genosample[h].srcpop][k][genosample[h].genotype[k]                   [0]]+(1.0/pow(2.0,(double)genosample[h].immage-2.0))*                      pmat[j][k][genosample[h].genotype[k][0]]*                                      pmat[genosample[h].srcpop][k][genosample[h].genotype[k][0]]);
		else
		  loglik+=log((1.0-1.0/pow(2.0,(double)genosample[h].immage-           2.0))*2.0*pmat[genosample[h].srcpop][k][genosample[h].genotype[k][0]]          *pmat[genosample[h].srcpop][k][genosample[h].genotype[k][1]]+                  (1.0/pow(2.0,(double)genosample[h].immage-2.0))*                               (pmat[j][k][genosample[h].genotype[k][0]]*                                     pmat[genosample[h].srcpop][k][genosample[h].genotype[k][1]]+                   pmat[j][k][genosample[h].genotype[k][1]]*                                      pmat[genosample[h].srcpop][k][genosample[h].genotype[k][0]]));
	  // loglik+=log((1.0-1.0/pow(2.0,(double)genosample[h].immage-           2.0))*2.0*pmat[genosample[h].srcpop][k][genosample[h].genotype[k][0]]          *pmat[genosample[h].srcpop][k][genosample[h].genotype[k][1]]+                  (1.0/pow(2.0,(double)genosample[h].immage-2.0))*                               (pmat[j][k][genosample[h].genotype[k][0]]*                                     pmat[genosample[h].srcpop][k][genosample[h].genotype[k][1]]+                   pmat[j][k][genosample[h].genotype[k][1]]*                                      pmat[genosample[h].srcpop][k][genosample[h].genotype[k][0]]));
		 
	}
  return(loglik);
}


/***************************************************
 *   Function indloglikgeno                        *
 *    calculate log Pr(X | M, t, p, s)             *
 *   - like loglikgeno, but this calculates one    *
 *      individual/locus at a time                 *
 ***************************************************/

double indloglikgeno(long h, long k, gdata genosample[MAXINDS], double migmat[MAXPOPS][MAXPOPS],double pmat[MAXPOPS][MAXLOC][MAXALLELE], double Fvalue[MAXPOPS])

{
  double loglik = 0.0;

  //  note: h and k are the individual and locus, respectively

  if (genosample[h].immanc==genosample[h].srcpop)            // if immigrant ancestry = sourcepop = j
    {
      if(genosample[h].genotype[k][0]==genosample[h].genotype[k][1])
	loglik = log(((1.0 - Fvalue[genosample[h].immanc]) * pow(pmat[genosample[h].immanc][k][genosample[h].genotype[k][0]], 2.0)) + (Fvalue[genosample[h].immanc] * pmat[genosample[h].immanc][k][genosample[h].genotype[k][0]]));
      else
	 loglik = log(2.0) + log(pmat[genosample[h].immanc][k][genosample[h].genotype[k][0]]) + log(pmat[genosample[h].immanc][k][genosample[h].genotype[k][1]]) + log(1.0 - Fvalue[genosample[h].immanc]);
    }

  else
    if (genosample[h].immage==1) // t=1
      if(genosample[h].genotype[k][0]==genosample[h].genotype[k][1])
	loglik = log(((1.0 - Fvalue[genosample[h].immanc]) * pow(pmat[genosample[h].immanc][k][genosample[h].genotype[k][0]], 2.0)) + (Fvalue[genosample[h].immanc] * pmat[genosample[h].immanc][k][genosample[h].genotype[k][0]]));
      else
	loglik = log(2.0) + log(pmat[genosample[h].immanc][k][genosample[h].genotype[k][0]]) + log(pmat[genosample[h].immanc][k][genosample[h].genotype[k][1]]) + log(1.0 - Fvalue[genosample[h].immanc]);

    else
      if(genosample[h].immage>1) // t>1
	if(genosample[h].genotype[k][0]==genosample[h].genotype[k][1])
	  loglik = log((1.0-1.0/pow(2.0,(double)genosample[h].immage-                     2.0))*pmat[genosample[h].srcpop][k][genosample[h].genotype[k]                  [0]]*pmat[genosample[h].srcpop][k][genosample[h].genotype[k]                   [0]]+(1.0/pow(2.0,(double)genosample[h].immage-2.0))*                          pmat[genosample[h].immanc][k][genosample[h].genotype[k][0]]*                   pmat[genosample[h].srcpop][k][genosample[h].genotype[k][0]]);
	else
	  loglik = log((1.0-1.0/pow(2.0,(double)genosample[h].immage-                    2.0))*2.0*pmat[genosample[h].srcpop][k][genosample[h].genotype[k][0]]          *pmat[genosample[h].srcpop][k][genosample[h].genotype[k][1]]+                  (1.0/pow(2.0,(double)genosample[h].immage-2.0))*                               (pmat[genosample[h].immanc][k][genosample[h].genotype[k][0]]*                  pmat[genosample[h].srcpop][k][genosample[h].genotype[k][1]]+                   pmat[genosample[h].immanc][k][genosample[h].genotype[k][1]]*                   pmat[genosample[h].srcpop][k][genosample[h].genotype[k][0]]));
 				
  return(loglik);
}


/***************************************************
 *  Function loglikgenosum                         *
 *    This function sums up the values derived in  *
 *    indloglikgeno                                *
 ***************************************************/

double loglikgenosum (long numinds, long numloc, double indllgenold[MAXINDS][MAXLOC])

{
  double loglik = 0.0;
  long i, j;

  for (i=1; i<=numinds; ++i)
    for (j=1; j<=numloc; ++j)
      loglik += indllgenold[i][j];

  return(loglik);
}


/***************************************************
 * Function logprMadj                              *
 *   Metropolis-Hastings adjustment for assymetry  *
 *   in some of the ancestral state changes        *
 ***************************************************/

double logprMadj (long cind, long pophists[MAXPOPS][MAXPOPS][MAXANC], gdata genosample[MAXINDS], gdata genochange[MAXINDS])

// double logprMadj (long anc, long numpops, long cind, gdata genosample[MAXINDS], gdata genochange[MAXINDS])

{
  double Madj = 0.0;
  Madj = (double)(pophists[genochange[cind].srcpop][genochange[cind].immanc][genochange[cind].immage] + 1.0) / (double)(pophists[genosample[cind].srcpop][genosample[cind].immanc][genosample[cind].immage]);
 
  /*
  if ((genosample[cind].immage == 1) && (genochange[cind].immage == 0))
    Madj = (double)(pophistage[genosample[cind].srcpop][0] + 1.0) / pophistage[genosample[cind].srcpop][1];
  if ((genosample[cind].immage == 2) && (genochange[cind].immage == 0))
    Madj = (double)(pophistage[genosample[cind].srcpop][0] + 1.0) / pophistage[genosample[cind].srcpop][2];
  if ((genosample[cind].immage == 2) && (genochange[cind].immage == 1))
    Madj = (double)(pophistage[genosample[cind].srcpop][1] + 1.0) / pophistage[genosample[cind].srcpop][2];
  if ((genosample[cind].immage == 0) && (genochange[cind].immage == 1))
    Madj = (double)(pophistage[genosample[cind].srcpop][1] + 1.0) / pophistage[genosample[cind].srcpop][0];
  if ((genosample[cind].immage == 1) && (genochange[cind].immage == 2))
    Madj = (double)(pophistage[genosample[cind].srcpop][2] + 1.0) / pophistage[genosample[cind].srcpop][1];
  if ((genosample[cind].immage == 0) && (genochange[cind].immage == 2))
  Madj = (double)(pophistage[genosample[cind].srcpop][2] + 1.0) / pophistage[genosample[cind].srcpop][0]; */
  /*
  if ((genosample[cind].immage == genochange[cind].immage) && (genosample[cind].immanc == genochange[cind].immanc))
    Madj = 1.0;
  else
    {
      if (genosample[cind].immage == 0)
	Madj = 0.5;
      else if (genochange[cind].immage == 0)
	Madj = 2.0 / 3.0;
      else
	Madj = 1.0 / 3.0;
    }
  */
  Madj = log(Madj);
  return(Madj);
}


//  if (genosample[cind].srcpop == genosample[cind].immanc)
//    Madj = 1.0 / (double)numpops;
//  else
//    Madj = (1.0 - (1.0 / (double)numpops)) * (1.0 / ((double)anc - 1.0));
//  Madj = log(Madj);
//  return(Madj);
// }


/****************************************************
 * Function maxcomp                                 *
 *   compares two integers and returns the largest  *
 *  - taken from immanc5, by J. Mountain            *
 ****************************************************/

int maxcomp(int i,int j)
{
if(i>j){return(i);}
else if(i<=j){return(j);}
}


/***************************************************
 * Function ran1                                   *
 *   random number generator                       *
 ***************************************************/


#define IA 16807
#define IM 2147483647
#define AM (1.0/IM)
#define IQ 127773
#define IR 2836
#define NTAB 32
#define NDIV (1+(IM-1)/NTAB)
#define EPS 1.2e-7
#define RNMX (1.0-EPS)

float ran1(long *idum)
{
	int j;
	long k;
	static long iy=0;
	static long iv[NTAB];
	float temp;

	if (*idum <= 0 || !iy) {
		if (-(*idum) < 1) *idum=1;
		else *idum = -(*idum);
		for (j=NTAB+7;j>=0;j--) {
			k=(*idum)/IQ;
			*idum=IA*(*idum-k*IQ)-IR*k;
			if (*idum < 0) *idum += IM;
			if (j < NTAB) iv[j] = *idum;
		}
		iy=iv[0];
	}
	k=(*idum)/IQ;
	*idum=IA*(*idum-k*IQ)-IR*k;
	if (*idum < 0) *idum += IM;
	j=iy/NDIV;
	iy=iv[j];
	iv[j] = *idum;
	if ((temp=AM*iy) > RNMX) return RNMX;
	else return temp;
}
#undef IA
#undef IM
#undef AM
#undef IQ
#undef IR
#undef NTAB
#undef NDIV
#undef EPS
#undef RNMX
/* (C) Copr. 1986-92 Numerical Recipes Software "25Bi..<!. */


/***********************************************
 * Function gammln                             *
 *   calculate gamma distribution              *
 ***********************************************/

#include <math.h>

float gammln(float xx)
{
	double x,y,tmp,ser;
	static double cof[6]={76.18009172947146,-86.50532032941677,
		24.01409824083091,-1.231739572450155,
		0.1208650973866179e-2,-0.5395239384953e-5};
	int j;

	y=x=xx;
	tmp=x+5.5;
	tmp -= (x+0.5)*log(tmp);
	ser=1.000000000190015;
	for (j=0;j<=5;j++) ser += cof[j]/++y;
	return -tmp+log(2.5066282746310005*ser/x);
}
/* (C) Copr. 1986-92 Numerical Recipes Software "25Bi..<!. */





// #include"immanc.h"
#define BUFFSIZE	256
#define MAXITERATIONS	10000
#define MINITERATIONS 100
#define	MAXGEN		5
#define DEFAULTALPHA	0.05

/* 
main program for detecting recent migrants among set of populations, based upon genotype data from RFLPs. 
lexicon code borrowed from "dnastat.c", by Eric Minch, Dept. of Genetics, Stanford University 
version 1.3 modifications by B. Rannala, 10/12/97 to obtain Windows Visual C compiler compatibility. 
modifications by J. Mountain, 2/25/98: indication of progress, significance level option for power tests, fix of filename read
Inserted into greg program by G. Wilson 2/13/02
*/

int main()
  // int main (int argc, char **argv) {
{

/* Scalars */
	FILE *infile, *outfile;
	int i,ii,m, g,gg,print;
	int ind, pop, mark, all, inds, pops, marks, alls, numGen;
	int fraction; 
	long iterations;
	char buffer[BUFFSIZE], infilename[BUFFSIZE],outfilename[BUFFSIZE],             tempinput[BUFFSIZE],temp[BUFFSIZE],comment[101],quitword[50];
	char  *indName, *popName, *markName, *allName;
	double alpha;
	
/* Vectors */
	int *nalleles,*indpop, *npopinds;

/* Matrices */
	int **data,**popData,**count,**indcount,**popinds;
	
/* Tensors*/
	int ***genotype,***absFreq;
	double ***power;
	
/* Structures */
	struct Lexicon *indNames;
	struct Lexicon *popNames;
	struct Lexicon *markNames;
	struct Lexicon *allNames;
	struct Lexicon **allList;
	
	/********************************************
	 * Notes on input file:                     *
	 *  1) file must be '.inp' or it will not   *
	 *      be read                             *
	 *  2) the program does not recognize       *
	 *      whether the default input file is   *
	 *      present or not, which could result  *
	 *      in segmentation faults.             *
	 *  In order to check for these errors, we  *
	 *   could make the program exit if a       *
	 *   pointer to the input file is not       *
	 *   recognized.  More details on this in   *
	 *   the C programming book.                *
	 *                                          *
	 *  The input file must be saved as UNIX,   *
	 *   and not dos.  The command dos2unix     *
	 *   can be used to do that.                *
	 ********************************************/

        cout << "BayesAss+ Inference of Recent Migrations Rates\n";
        cout << "Copyright 2003, Greg Wilson, University of Alberta\n\n";

        
	// Get user inputs
#ifdef CPLUS
	cout << "These variables can be defined by the user.  Input the number of the variable whose value you would like to change." << '\n' << '\n';
	strcpy(ofile, "output.txt");
	while (done == false)
	  {
	    if ((sampfreq > numits) || (burnin > numits))
	      cout << '\n' << "The number of iterations should be greater than both the sampling frequency and the burn-in length!!" << '\n' << '\n';
            cout << '\n' << "1) Seed is " << -(idum) << '\n';
	    cout << "2) Number of iterations is " << numits << '\n';
	    cout << "3) Sampling frequency is " << sampfreq << '\n';
	    cout << "4) Length of the burn-in is " << burnin << '\n';
	    cout << "5) Delta value for allele frequency is " << deltapinput << '\n';
	    cout << "6) Delta value for migration rate is " << deltaminput << '\n';
	    cout << "7) Delta value for F is " << deltaFinput << '\n';
	    cout << "8) Name of output file is " << ofile << '\n';
	    cout << "22) Continue" << '\n' << '\n';
	    cout << "What option would you like?  ";
	    (void) fgets(line, sizeof(line), stdin);
	    (void) sscanf(line, "%d", &option1);
	    switch (option1)
	      {
	      case 1:
		cout << "Input a new seed (a positive integer):  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &idum);
		idum = -idum;
		cout << '\n';
		break;
	      case 2:
		cout << "Input the number of iterations for the chain:  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &numits);
		break;
	      case 3:
		cout << "Input the frequency samples will be taken from the chain:  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &sampfreq);
		break;
	      case 4:
		cout << "Input the desired length of the burn-in:  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &burnin);
		break;
	      case 5:
		cout << "Input the delta value for allele frequencies (should be an integer between 0 and 100, and the optimal value is likely less than 35):  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &deltapinput);
		break;
	      case 6:
		cout << "Input the delta value for migration rates (should be an integer between 0 and 100, and the optimal value is likely less than 35):  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &deltaminput);
		break;
	      case 7:
		cout << "Input the delta value for F values (should be an integer between 0 and 100, and the optimal value is likely less than 35):  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &deltaFinput);
		break;
	      case 8:
		cout << "Input the new name for the output file, using normal file-naming rules, and using the appropriate suffix, i.e., '.txt':  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%s", &ofile);
		break;
	      case 22:
		done = true;
		break;
	      default:
		cout << "Not a valid choice.  Please try again." << '\n';
		break;
	      }
	  }
	// strcat(ofile, ".txt");
	deltaminit = double (deltaminput) / 100.0;
	deltap = double (deltapinput) / 100.0;
	deltaF = double (deltaFinput) / 100.0;
	deltam = deltaminit;

	cout << '\n' << '\n' << "The following statements allow you to set the types of information that will appear in the output file " << ofile << ".  Values set at 1 will be printed, and any other integer will not be printed.  Input the number of the variable you would like to change." << '\n' << '\n';

	done = false;
	while (done == false)
	  {
	    cout << "1) User-defined settings is currently set at " << settings << '\n';
	    cout << "2) Genotype and sampling information is currently set at " << pdata << '\n';
	    cout << "3) The mean and variance of the posterior probabilities for each allele is currently set at " << allelepost << '\n';
	    cout << "4) The mean and variance of the posterior probabilities for the F values is currently set at " << Fpost << '\n';
	    cout << "5) The assignment for each individual is currently set at " << assign << '\n';
	    cout << "6) Posterior probabilities for missing data is currently set at " << mdatapost << '\n';
	    cout << "7) Individual assignments summed over populations is currently set at " << popassign << '\n';
	    cout << "8) The mean and variance of the posterior probabilities for the migration rates is currently set at " << migpost << '\n';
	    cout << "9) The number of times the proposed changes were accepted is currently set at " << nchanges << '\n';
	    cout << "10) The number of times each frequency falls within 0.05 intervals is currently set at " << Fafinal << '\n';
	    cout << "11) Changes in log likelihood values is currently set at " << Llvaluesrun << '\n';
	    cout << "12) The distribution of log likelihood values when the chain was sampled is currently set at " << Llvaluessum << '\n';
	    cout << "13) The likelihood ratio test of the prior and the posterior distributions of the migration rates is currently set at " << chi2print << '\n'; 
	    cout << "22) Continue" << '\n' << '\n';
	    cout << "What option would you like?  ";
	    (void) fgets(line, sizeof(line), stdin);
	    (void) sscanf(line, "%d", &option2);
	    switch (option2)
	      {
	      case 1:
		cout << "Enter '1' to display user-defined settings, any other integer otherwise:  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &settings);
		break;
	      case 2:
		cout << "Enter '1' to display genotype and sampling information, any other integer otherwise:  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &pdata);
		break;
	      case 3:
		cout << "Enter '1' to display mean and variance of the posterior probilities for the allele frequencies, any other integer otherwise:  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &allelepost);
		break;
	      case 4:
		cout << "Enter '1' to display mean and variance of the posterior probilities for F, any other integer otherwise:  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &Fpost);
		break;
	      case 5:
		cout << "Enter '1' to display the individual assignments, any other integer otherwise:  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &assign);
		break;
	      case 6:
		cout << "Enter '1' to display the posterior probilities for the missing data, any other integer otherwise:  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &mdatapost);
		break;
	      case 7:
		cout << "Enter '1' to display the assignments summarized over populations, any other integer otherwise:  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &popassign);
		break;
	      case 8:
		cout << "Enter '1' to display mean and variance of the posterior probilities for the migration rates, any other integer otherwise:  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &migpost);
		break;
	      case 9:
		cout << "Enter '1' to display the number of times each proposed change was accepted, any other integer otherwise:  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &nchanges);
		break;
	      case 10:
		cout << "Enter '1' to display the number of times each frequency falls within 0.05 intervals, any other integer otherwise:  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &Fafinal);
		break;
	      case 11:
		cout << " Enter '1' to display log likelihoods throughout the run, any other integer otherwise:  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &Llvaluesrun);
		break;
	      case 12:
		cout << "Enter '1' to display the summary of log likelihood values when the chain was sampled, any other integer otherwise: ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &Llvaluessum);
		break;
	      case 13:
		cout << "Enter '1' to display the likelihood ratio test of the prior versus the posterior distribution of the migration rates, any other integer otherwise:  ";
		(void) fgets(line, sizeof(line), stdin);
		(void) sscanf(line, "%d", &chi2print);
		break;
	      case 22:
		done = true;
		break;
	      default:
		cout << "Not a valid choice.  Please try again." << '\n';
	      }
	  }
#endif

	for (i=1; i<=MAXINDS; ++i)
	  {
	    indmissing[i] = 0;
	    for (j=1; j<=MAXLOC; ++j)
	      datagone[i][j] = 0;
	  }

	//	ofstream examplefile ("og6faster823.txt");   // added by GW so that inputted data is sent to a text file and can be examined there
	//strcpy(ofile, "uniF");
	do 
	{
	    cout << '\n';
            cout << "Name of input file: ";
            
         //   printf("\nName of input file: ");    this is C++ after all!
            
	//	gets(infilename);	bad syntax bruce changed

            cin >> infilename; 
            
		if (strlen(infilename))
		  {
			infile=fopen(infilename, "r");
			//	strcat (ofile, infilename);
		  }
		else
			infile=stdin;
		if (infile==NULL)
			printf("Can't find data file named %s\n", infilename);
	} while (infile==NULL);
	/*	do 
	{
		printf("Name of output file (RETURN for stdout): ");
		gets(outfilename);
		if (strlen(outfilename))
			outfile=fopen(outfilename, "w");
		else
			outfile=stdout;
		if (outfile==NULL)
			printf("Can't create output file named %s\n", outfilename);

			} while (outfile==NULL);  */
        outfile = stdout;
        if (outfile == NULL)
            printf("Can't create output file");
        print = 0;
        
        //	cout << ofile;
	ofstream examplefile(ofile);
	//	cout << "Real values are:" << '\n';
	//	cout << "idum: " << idum << '\n';
	//	cout << "deltap: " << deltap << '\n';
	//	cout << "deltam: " << deltam << '\n';
	//	cout << "deltaF: " << deltaF << '\n';
	//	cout << "number of iterations: " << numits << '\n';
	//	cout << "burnin:  " << burnin << '\n';
	//	cout << "sampfreq:  " << sampfreq << '\n' << '\n';

	if (settings == 1)
	  {
	    examplefile << "************** USER-DEFINED SETTINGS **************" << '\n' << '\n' << '\n';
	    examplefile << "number of iterations is " << numits << ", of which " << burnin << " are burnin, and the sampling frequency is " << sampfreq <<'\n';
	    examplefile << "deltap (allele freq) is " << deltapinput << '\n';
	    examplefile << "deltam (mig rate) is " << deltaminput << '\n';
	    examplefile << "deltaF (inbreeding) is " << deltaFinput << '\n';
	    examplefile << "initial value of idum is " << -(idum) << '\n' << '\n';
	  }
	//	printf("Print out data? ");
	//	gets(tempinput);
	//	if (strncmp(tempinput,"y",1)==0 || strncmp(tempinput,"Y",1)==0) 
	//	print = 1;
	//	printf("Comment line to be included in output (max 100 characters): ");
	//	gets(comment);
	/*   GW removed this section: generation number will not be determined by user
	printf("Number of generations in past: ");
	gets(tempinput);
	if (strlen(tempinput))
		numGen = atoi(tempinput) + 1;
	else numGen = 1;
	if (numGen > MAXGEN) 
	{
		printf("\n *** Current maximum number of generations is: %d.\n %d generations will be considered.*** \n\n",MAXGEN-1,MAXGEN-1);
		numGen = MAXGEN;
	}
	
	printf("Number of replications: ");
	gets(tempinput);
	if (strlen(tempinput)) 
	{
		iterations = atoi(tempinput);
		if (iterations < MINITERATIONS)
		{
			printf("\n *** Current minimum number of replications is: %d.  %d replications will be carried out. \n\n",MINITERATIONS,MINITERATIONS);
			iterations = MINITERATIONS;
		}
		else if (iterations > MAXITERATIONS)
		{
			printf("\n *** Current maximum number of replications is: %d.  %d replications will be carried out. \n\n",MAXITERATIONS,MAXITERATIONS);
			iterations = MAXITERATIONS;
		}
		
	}
	else
		iterations = MINITERATIONS;
	cout << "the value for iterations is " << iterations << '\n';
	*/

	/*   GW removed this for now: use default alpha
	printf("Significance level for power tests (default is 0.05): ");
	gets(tempinput);
	if (strlen(tempinput)) 
		alpha = atof(tempinput);
	else
		alpha = DEFAULTALPHA;
	fraction = 1.0/alpha;
	if (fraction > iterations)
	{
		printf("\n Significance level too low given the number of iterations - set to %d \n",DEFAULTALPHA);
		fraction = 20;
		alpha = DEFAULTALPHA;
	}
	*/

/*	printf("Include individual in allele frequency counts (default is yes)?");
	gets(tempinput);
	if (strlen(tempinput))
	{
		if (strncmp(tempinput,"n",1)==0 || strncmp(tempinput,"N",1)==0) 
			exclude = 1;
	}
	else
		exclude = 0;
		
*/

		
/* Allocate structures */
	indNames=initLexicon();
	popNames=initLexicon();
	markNames=initLexicon();
	allNames=initLexicon();
	nalleles=(int *)malloc(sizeof(int));
 
	if (outfile != stdout) 
		printf("\n Reading data file ... \n");

/* Count the individuals, populations, loci, and alleles, and build the lexicons */
	inds=pops=marks=alls=0;
	while (fgets(buffer, BUFFSIZE, infile)) if ((strlen(buffer)>1)&&(buffer[0]!='%')) {
		indName=strtok(buffer, " \t");
		ind=getLexWord(indNames, indName);
		inds=maxcomp(ind, inds);
		popName=strtok(NULL, " \t");
		pop=getLexWord(popNames, popName);
		pops=maxcomp(pop, pops);
      		markName=strtok(NULL, " \t");
		if (!(mark=findLexWord(markNames, markName))) {
			mark=getLexWord(markNames, markName);
			marks=maxcomp(mark, marks);
      			nalleles=(int *)realloc(nalleles, marks*sizeof(int));
			nalleles[mark-1]=0;
		}
		
		allName=strtok(NULL, " \t");
		if ((strcmp(allName, missing1)) && (strcmp(allName, missing2)) && (strcmp(allName, missing3)))
		    {
		      memset(temp, 0, BUFFSIZE);
		      memmove(temp, markName, strlen(markName));
		      temp[strlen(markName)]='*';
		      memmove(temp+strlen(markName)+1, allName, strlen(allName));
		      temp[strlen(markName)+strlen(allName)+1]=0;
		      if (!(all=findLexWord(allNames, temp))) {
			  all=getLexWord(allNames, temp);
			  alls=maxcomp(all, alls);
       			  nalleles[mark-1]++;
		      }
		    }
		allName=strtok(NULL, " \t\n");
		if ((strcmp(allName, missing1)) && (strcmp(allName, missing2)) && (strcmp(allName, missing3)))
	            {
		      memset(temp, 0, BUFFSIZE);
		      memmove(temp, markName, strlen(markName));
		      temp[strlen(markName)]='*';
		      memmove(temp+strlen(markName)+1, allName, strlen(allName));
		      temp[strlen(markName)+strlen(allName)+1]=0;
		      if (!(all=findLexWord(allNames, temp))) {
			all=getLexWord(allNames, temp);
			alls=maxcomp(all, alls);
			nalleles[mark-1]++;
		      }
		   }
	}
	freeLexicon(allNames);

/* Allocation and Initialization */

	indpop = (int *) malloc(inds * sizeof(int));
	genotype = (int ***) malloc(inds * sizeof(int **));
	data = (int **) malloc(inds * sizeof(int *));
	count = (int **) malloc(inds * sizeof(int *));
	for (i=0;i<inds;i++) {
		genotype[i] = (int **) malloc(marks * sizeof(int *));
		data[i] = (int *) malloc(marks * sizeof(int));
		count[i] = (int *) malloc(inds * sizeof(int));
		for (m = 0; m< marks; m++) {
			genotype[i][m] = (int *) malloc(2 * sizeof(int));
			data[i][m] = 0;
		}	
		for (ii=0; ii<inds; ii++){
			count[i][ii] = 0;
		}		
	}	
	npopinds = (int *) malloc(pops * sizeof(int));
	absFreq = (int ***) malloc(pops * sizeof(int *));
	indcount = (int **) malloc(pops * sizeof(int *));
	popinds = (int **) malloc(pops * sizeof(int *));
	for (g = 0; g< pops; g++) {
		indcount[g] = (int *) malloc(marks * sizeof(int));
		popinds[g] = (int *) malloc(inds * sizeof(int));
		absFreq[g] = (int **) malloc(marks * sizeof(int *));
		for (m = 0; m< marks;m++)
			absFreq[g][m] = (int *) malloc(alls * sizeof(int));
	}	

	/* B.R. cleaned up J.M's sloppy memory allocation */
	/* not used in this program
	randomRatiosGivenG = (double *)malloc((size_t)(iterations+1) * sizeof(double));
	randomRatiosGivenGG = (double *)malloc((size_t)(iterations+1) * sizeof(double));
	randomRatiosMixGivenG = (double *)malloc((size_t)(iterations+1) * sizeof(double));
	randomRatiosGivenMix = (double *)malloc((size_t)(iterations+1) * sizeof(double));
	*/

	popData = (int **) malloc(pops * sizeof(int *));
	for (g = 0; g< pops; g++) 
		popData[g] = (int *) malloc(marks * sizeof(int));	
		
	power = (double ***) malloc(pops * sizeof(double *));
	for (g=0;g<pops;g++) 
	{
		power[g] = (double **) malloc(pops * sizeof(double *));
		for (gg=0;gg<pops;gg++)
			power[g][gg] = (double *) malloc(numGen * sizeof(double));	
	}	
		
		
/* Structures */
	allList=(struct Lexicon **) malloc(marks*sizeof(struct Lexicon *));
	for (i=0; i<marks; i++)
		allList[i]=initLexicon();

	
/* Read the data */
	rewind(infile);
	while (fgets(buffer, BUFFSIZE, infile)) if ((strlen(buffer)>1)&&(buffer[0]!='%')) {
		indName=strtok(buffer, " \t");
		ind=findLexWord(indNames, indName)-1;
		popName=strtok(NULL, " \t");
		pop=findLexWord(popNames, popName)-1;
		indpop[ind] = pop;
		markName=strtok(NULL, " \t");
		mark=findLexWord(markNames, markName)-1;
		allName=strtok(NULL, " \t");
		if ((!strcmp(allName, missing1)) || (!strcmp(allName, missing2)) || (!strcmp(allName, missing3)))
		  {
		    genotype[ind][mark][0] = 0;
		    indmissing[ind+1] = 1;
		    datagone[ind+1][mark+1] = 1;
		    ++missingdata;
		  }
                else
		  {
		    all=getLexWord(allList[mark], allName)-1;
		    genotype[ind][mark][0] = all;
		  }
		allName=strtok(NULL, " \t\n");
		if ((!strcmp(allName, missing1)) || (!strcmp(allName, missing2)) || (!strcmp(allName, missing3)))
		  genotype[ind][mark][1] = 0;
                else
                  { 
		    all=getLexWord(allList[mark], allName)-1;
		    genotype[ind][mark][1] = all;
		  }
		data[ind][mark] = 1;
		
	}
	fclose(infile);
	
/* How many individuals per population?  Which individuals in population? */
	for (g=0;g<pops;g++)
		npopinds[g] = 0;
	for (i=0;i<inds;i++)
		++npopinds[indpop[i]];
	for (g=0;g<pops;g++)
	{
		ii = 0;
		for (i=0;i<inds;i++)
			if (indpop[i] == g)
			{
				popinds[g][ii] = i;
				ii++;
			}
	}		

	fprintf(outfile,"\n%s\n",comment);

	if (outfile != stdout) 
		printf("\n Writing out data ... \n");

/* print out data */
	if (pdata == 1)
	  {    
	//  fprintf(outfile,"\n Data: \n\n        Pop        Ind     Marker             Genotype \n");
	   // examplefile << "POP       IND         MARKER    GENOTYPE " << '\n';
	   examplefile << "Loci are:" << '\n';
	   for (m = 0; m < marks; ++m)
	     examplefile << lexWord(markNames, m+1) << '\t';
	   examplefile << '\n' << '\n';
	   examplefile << "Individual     sampled pop     allele11, allele12 etc." << '\n';
	   for (g=0;g<pops;g++)
	     {
		for (ii=0;ii<npopinds[g];ii++)
		{
		  i = popinds[g][ii];  // individual ii in population g
		  examplefile << lexWord(indNames, i+1) << '\t' << lexWord(popNames, g+1) << '\t';
		  // examplefile << "individual " << i+1 << " is " << lexWord(indNames, i+1) << ", and has a srcpop of " << lexWord(popNames, g+1) << '\n';
		  //  genosample[i+1].srcpop = g+1;
			for (m = 0; m< marks; m++)
				if (data[i][m])
				  {
				    //			fprintf(outfile,"  %10.7s %10.7s %10.7s %10.7s %10.7s\n",lexWord(popNames, g+1), lexWord(indNames, i+1), lexWord(markNames, m+1), lexWord(allList[m], genotype[i][m][0]+1),lexWord(allList[m], genotype[i][m][1]+1));
				    //   genosample[i+1].genotype[m+1][0] = genotype[i][m][0]+1;
				    //   genosample[i+1].genotype[m+1][1] = genotype[i][m][1]+1;
					//	examplefile << lexWord(popNames, g+1) << "      " <<  lexWord(indNames, i+1) << "      " << lexWord(markNames, m+1) << "      " << lexWord(allList[m], genotype[i][m][0]+1) << "  " << lexWord(allList[m], genotype[i][m][1]+1) << '\n';
					examplefile << lexWord(allList[m], genotype[i][m][0]+1) << ", " << lexWord(allList[m], genotype[i][m][1]+1) << "      ";

				  }
			examplefile << '\n';
		}
		examplefile << '\n';
	     }
	   }
	   	   
    for (g=0; g<pops; ++g)
      {
	for (ii=0; ii<npopinds[g]; ++ii)
	  {
	    i = popinds[g][ii];  // individual ii in population g
	    genosample[i+1].srcpop = g+1;
	    for (m=0; m<marks; ++m)
	      {
		if (data[i][m])
		  {
		    genosample[i+1].genotype[m+1][0] = genotype[i][m][0]+1;
		    genosample[i+1].genotype[m+1][1] = genotype[i][m][1]+1;
		  }
	      }
	  }
      }
	   
	for (g=0; g<marks; ++g)
	  {
	    cout << "locus " << g+1 << " (" << lexWord(markNames, g+1) << ") has " << nalleles[g] << "  alleles:" << '\n';
	    for (i=1; i<=nalleles[g]; ++i)
	      cout << "allele " << i << ": " << lexWord(allList[g], i) << '\n';
	  }
	
	/*  	for (g=1; g<=inds; ++g)
	 for (i=0; i<marks; ++i)
	  {
	    for (m=1; m<=nalleles[i]; ++m)
	      if (genosample[g].genotype[i+1][0] == m)
	    	  examplefile << "individual " << lexWord(indNames, g) << " has a first allele of " << lexWord(allList[i], m);
	    for (m=1; m<=nalleles[i]; ++m)
	    	if (genosample[g].genotype[i+1][1] == m)
	    	  examplefile << " and allele two is " << lexWord(allList[i], m) << '\n';
	  }  
	for (g=1; g<=inds; ++g)
	  for (i=1; i<=pops; ++i)
	    if (genosample[g].srcpop == i)
	      examplefile << "individual " << lexWord(indNames, g) << " has a srcpop of " << lexWord(popNames, i) << '\n';
	      //  examplefile << "individual " << g << " has a srcpop of " << genosample[g].srcpop << '\n';
	      */
		
	cout << "\n\n********************************************************************";
	cout << "\n********** BayesAss+ Migration Rate Estimation version 1.20*********";
	cout << "\n********************************************************************\n\n";
	cout << "\n\nAnalyses of data for " << inds << " individuals and " << marks << " loci.\n";
	cout << "There are " << pops << " populations" << '\n';			
	//	fprintf(outfile,"\n\n Testing for %d generations into the past; %d iterations per test.\n",numGen-1, iterations);
	//	cout << "The names of the loci are:" << '\n';
	//for (g=1; g<=marks; ++g)
	//  cout << "locus " << g << " is " << lexWord(markNames, g) << '\n';			
	// }

	/******************************************
	 *  Below is the part of the program      *
	 *   supplied by GW.  Note that the       *
         *   lexWord(allList[g]) starts at 0      *
	 *   while the lexWord(markNames) starts  *
	 *   at 1, so they don't line up.         *
	 *   Also, for the program below, alleles *
	 *   start at 0, while above they start   *
	 *   at 1.  Make sure to remember this    *
	 *   when renaming!                       *
	 ******************************************/

	// main()
	// {
	// ofstream examplefile ("outputw4.txt");
  numinds=inds;             
  numpops=pops;
  numloci=marks;
  //  numchange = 5;
  maxminit = 0.1;        // maximum initial migration rate (for ancestry assignments only)
  // numalleles[1] = 2;     
  for (g=0; g<marks; ++g)
    {
      numalleles[g+1] = nalleles[g];
      cout << "locus " << g+1 << ", which is " << lexWord(markNames, g+1) << " has " << numalleles[g+1] << " alleles." << '\n';
    }
  for (g=1; g<=numloci; ++g)
    numallelesold[g] = numalleles[g];
  numdivsp = 20;
  numdivsm = 20;
  numdivsF = 20;
  // sampfreq = 2000;
  Finit = 0.1;
  // deltap = 0.1;
  // deltam = 0.1;
  // deltaF = 0.1;    // This may be better as 0.2, depending on the data set
  deltai = 0.1;
  anc = 3;
  counter = 0;

  // set to 0 all variables that will be required later
  for (i=1; i<=numpops; ++i)
    for (j=1; j<=numloci; ++j)
      for (k=0; k<numalleles[j]; ++k)
	for (m=1; m<=numdivsp; ++m)
	  allfreqhis[i][j][k][m] = 0;
  for (i=1; i<=numpops; ++i)
    for (j=1; j<=numpops; ++j)
      for (m=1; m<=numdivsm; ++m)
	mfreqhis[i][j][m] = 0;
  for (i=1; i<=numpops; ++i)
    for (j=1; j<=numdivsF; ++j)
      Ffreqhis[i][j] = 0;
  for (i=1; i<=numpops; ++i)
    for (j=1; j<=numloci; ++j)
      for (k=0; k<numalleles[j]; ++k)
	{
	  meannew[i][j][k] = 0;
	  meanold[i][j][k] = 0;
	  varnew[i][j][k] = 0;
	  varold[i][j][k] = 0;
	}
  for (i=1; i<=numpops; ++i)
    for (j=1; j<=numpops; ++j)
      {
        meannewm[i][j] = 0;
        meanoldm[i][j] = 0;
        varnewm[i][j] = 0;
        varoldm[i][j] = 0;
      }
  for (i=1; i<=numinds; ++i)
    for (j=1; j<=numloci; ++j)
      {
        indllgenold[i][j] = 0;
	indllgennew[i][j] = 0;
      }
  for (i=1; i<=numpops; ++i)
    popsums[i] = 0;

  //  cout << "numinds is " << numinds << ", numpops is " << numpops << ", and numloci is " << numloci << '\n' << '\n';;

   // remove any loci that are monomorphic
  /*
  numlocold = numloci;
  for (g=1; g<=numlocold; ++g)
    if (numalleles[g] == 1)
      {
	Lmonomorphic[g] = 1;
	-- numloci;
      }
  if (numlocold != numloci)
    {
      examplefile << '\n' << "Monomorphic loci!  These will not be included in the analysis." << '\n';
      examplefile << "They are:" << '\n';
      for (i=1; i<=numlocold; ++i)
	if (Lmonomorphic[i] == 1)
	  examplefile << "Locus " << lexWord(markNames, i) << '\n';
      examplefile << '\n';
    }

    if (numlocold != numloci)
      {
	counter = 1;
	for (i=1; i<= numloci; ++i)
	  {
	    if (Lmonomorphic[counter] == 1)
	      {
		j=1;
		while (j == 1)
		  {
		    ++ counter;
		    if (Lmonomorphic[counter] == 0)
		      {
		        break;
			j = 0;
		      }
		  }
	      }
	    numalleles[i] = numalleles[counter];
	    for (p=1; p<=numinds; ++p)
	      {
	        genosample[p].genotype[i][0] = genosample[p].genotype[counter][0];
		genosample[p].genotype[i][1] = genosample[p].genotype[counter][1];
	      }
	    ++ counter;
	  }
      }

    for (i=1; i<=numloci; ++i)
      {
	//	cout << "for locus " << i << '\n';
        if (i == 1)
	  {
	    //  cout << "i=1, g is set to 1" << '\n';
	    g = 1;
	  }
	else
	  {
	    g = newLname[i-1] + 1;
	    //  cout << "i is not 1. g is " << g << '\n';
	  }
	j = 1;
	while (j == 1)
	  {
	    if (Lmonomorphic[g] == 0)
	      {
	        newLname[i] = g;
		j = 0;
		break;
	      }
	    ++ g;
	  }
	++ g;
      }
  */
    //  cout << "number of polymorphic loci is " << numloci << '\n';
    // cout << "Status of each locus:" << '\n';
    //  for (i=1; i<=numlocold; ++i)
    // cout << "Lmonomorphic for locus " << i << " is " << Lmonomorphic[i] << '\n';
    // for (i=1; i<=numinds; ++i)
    //{
    //  cout << "Genotype for individual " << i << '\n';
    //  for (j=1; j<=numloci; ++j)
    //    {
    //      cout << "  genotype at Locus " << j << " is " << genosample[i].genotype[j][0] << ", " << genosample[i].genotype[j][1] << '\n';
    //    }
    //}
  // for (j=1; j<=numloci; ++j)
  //  cout << "Locus " << j << " has " << numalleles[j] << " alleles " << '\n';
  //  cout << "There are " << numloci << " loci " << '\n';

  // this adjusts the value of the allele number down 1, so it starts at 0
  // it also sets missing data uniformly
  for (i=1; i<=numinds; ++i)
    {
      for (g=1; g<=numloci; ++g)
        {
	  if (datagone[i][g] == 1)
	    {
	      for (k=0; k<=1; ++k)
		{
		  rvx = ran1(&idum);
		  for (m=0; m<numalleles[g]; ++m)
		    {
		      if (rvx >= ((float)m / (float)numalleles[g]))
			callele = m;
		    }
		  genosample[i].genotype[g][k] = callele;
		}
	    }
          else
	    {
	      genosample[i].genotype[g][0] = genosample[i].genotype[g][0] - 1;
              genosample[i].genotype[g][1] = genosample[i].genotype[g][1] - 1;
	    }
	  genochange[i].genotype[g][0] = genosample[i].genotype[g][0];
	  genochange[i].genotype[g][1] = genosample[i].genotype[g][1];
        }
    }
  /*
  for (i=1; i<=numloci; ++i)
    {
      cout << "locus " << i << " has name " << newLname[i] << '\n';
      for (j=1; j<=numalleles[i]; ++j)
      cout << "allele " << j << " is " << lexWord(allList[newLname[i]-1], j) << '\n';
    }
  */
  /* examplefile << '\n' << "The following are the adjusted allele names, and the first alleles selected for missing data" << '\n';
  for (g=1; g<=numinds; ++g)
    {
      examplefile << "Individual " << g << '\n';
    for (i=1; i<=numloci; ++i)
      examplefile << "     locus " << i << " is: " << genosample[g].genotype[i][0] << 't' << genosample[g].genotype[i][1] << '\n';
      }  */

  for (i=1; i<=numpops; ++i)      // this sets initial inbreeding rates
    {
      // Fvalue[i] = Finit;
      // Fnew[i] = Fvalue[i];
      rvx = ran1(&idum);
      // rvx = (rvx * Finit * 2.0) - Finit;
      Fvalue[i] = rvx * Finit;
      Fnew[i] = Fvalue[i];
      // examplefile << "Fvalue " << i << " is " << Fvalue[i] << '\n';
    }
  // examplefile << '\n';
  /*  for(i=1;i<=numpops;i++)             // this sets migration rate 
    for(j=1;j<=numpops;j++)               // among populations.  Keep it.
      {
	if (i != j)
	  {
	    migmat[i][j] = maxminit / ((double)numpops - 1.0);
	    cmigmat[i][j] = migmat[i][j];
	  }
        else
	  {
	    migmat[i][j] = 1.0 - maxminit;
	    cmigmat[i][j] = migmat[i][j];
	  }
	// examplefile << "initial value of migmat " << i << ", " << j << " is " << migmat[i][j] << '\n';
	}
  */

  // Set initial migration rates uniformly

  for (i=1; i <= numpops; ++i)
    {
      rvx = ran1(&idum);
      migmat[i][i] = (rvx / 10.0) + 0.7;    // ensures non-migration rate is bound between (0.7, 0.8)
      //  cout << "nonmigration rate " << i << " is " << migmat[i][i] << '\n';
    }

  if (numpops == 2)
    {
      for (j=1; j <= numpops; ++j)
        for (i=1; i <= numpops; ++i)
	  if (i != j)
	    migmat[i][j] = 1.0 - migmat[j][j];
    }
  else
    {
      for (j=1; j <= numpops; ++j)
        {
	  while (1)
	    {
	      w = 0;
	      a = 1;
	      b = j;
	      if (j == 1)
	        a = 2;
	      migmat[a][b] = 1.0;
	      if (j == 1)
	        {
		  for (i=3; i <= numpops; ++i)
		    {
		      rvx = ran1(&idum);
		      migmat[i][j] = rvx * 2.0 / ((double)numpops - 1.0);
		      if ((migmat[i][j] * (1.0 - migmat[j][j])) < minfreq)
			{
			  w = 1;
			  continue;
			}
		      migmat[a][b] -= migmat[i][j];
		    }
	        }
	      else if (j == numpops)
	        {
		  for (i=2; i < numpops; ++i)
		    {
		      rvx = ran1(&idum);
		      migmat[i][j] = rvx * 2.0 / ((double)numpops - 1.0);
		      if ((migmat[i][j] * (1.0 - migmat[j][j])) < minfreq)
			{
			  w = 1;
			  continue;
			}
		      migmat[a][b] -= migmat[i][j];
		    }
	        }
	      else
	        {
	          for (i=2; i <= numpops; ++i)
		    {
		      if (i == j)
		        ++ i;
		      rvx = ran1(&idum);
		      migmat[i][j] = rvx * 2.0 / ((double)numpops - 1.0);
		      if ((migmat[i][j] * (1.0 - migmat[j][j])) < minfreq)
			{
			  w = 1;
			  continue;
			}
		      migmat[a][b] -= migmat[i][j];
		    }
	        }
	    if (((migmat[a][b] * (1.0 - migmat[j][j])) < minfreq) || (migmat[a][b] > (2.0 / ((double)numpops - 1.0))))
	      {
	        w = 1;
	        continue;
	      }
            else
	      break;
	  }
       }

  for (j=1; j <= numpops; ++j)
    {
      summ = 0;
      for (i=1; i <= numpops; ++i)
	{
	  // cout << "migmat[" << i << "][" << j << "] is " << migmat[i][j] << '\n';
	  //  cmigmat[i][j] = migmat[i][j];
          if (i != j)
	    migmat[i][j] = migmat[i][j] * (1.0 - migmat[j][j]);
	  //  cout << "migmat[" << i << "][" << j << "] is " << migmat[i][j] << '\n';
	  summ += migmat[i][j];
	  // cmigmat[i][j] = migmat[i][j];
	}
      //  cout << "migration rates into population " << j << " sum to " << summ << '\n';
    }
}
  //  examplefile << '\n';
  for (j=1; j <= numpops; ++j)
    for (i=1; i <= numpops; ++i)
      {
        cmigmat[i][j] = migmat[i][j];
	//examplefile << "migmat[" << i << "][" << j << "] is " << migmat[i][j] << ", cmigmat is " << cmigmat[i][j] << '\n';
      }

  /*
  for (i=1; i<=(numpops-1); ++i)
    {
      while(1)
	{
	  migmat[i][numpops] = 1.0 - initmii;
	  for (j=1; j<=(numpops-1); ++j)
	    {
	      if (i==j)
		{
		  migmat[i][j] = initmii;
		}
	      else
		{
		  rvx = ran1(&idum);
		  migmat[i][j] = ((rvx * 2.0 * (1.0 - initmii)) / (numpops - 1.0));
		  migmat[i][numpops] = migmat[i][numpops] - migmat[i][j];
		}
	    }
	  if ((migmat[i][numpops] < 0) || (migmat[i][numpops] > ((2.0 * (1.0 - initmii)) / (numpops - 1.0))))
	    continue;
	  break;
	}
    }
  while(1)
    {
      migmat[numpops][numpops] = initmii;
      migmat[numpops][numpops-1] = 1.0 - initmii;
      for (j=1; j<=(numpops-2); ++j)
	{
	  rvx = ran1(&idum);
	  migmat[numpops][j] = ((rvx * 2 * (1.0 - initmii)) / (numpops - 1.0));
	  migmat[numpops][numpops-1] = migmat[numpops][numpops-1] - migmat[numpops][j];
	}
      if ((migmat[numpops][numpops-1]<0) || (migmat[numpops][numpops-1] > ((2.0 * (1.0 - initmii)) / (numpops - 1.0))))
	continue;
      break;
    }
  for (i=1; i<=numpops; ++i)
    for (j=1; j<=numpops; ++j)
      {
	//        cout << "migmat[" << i << "][" << j << "] is " << migmat[i][j] << '\n';  
	cmigmat[i][j] = migmat[i][j];
      }
  */

  /*            test data
  for (i=1; i<=2; ++i)
    for (j=1; j<=100; ++j)
      {
        q = ((i-1)*100) + j;
        genosample[q].srcpop = i;
	if (j <= 70)
         {
	  genosample[q].immanc = i;
	  genosample[q].immage = 0;
	 }
	else if ((j > 70) && (j <= 80))
	{
	  genosample[q].immage = 1;
	  if (i==1)
	    genosample[q].immanc = 2;
	  else
	    genosample[q].immanc = 1;
	}
        else
	{
	  genosample[q].immage = 2;
	  if (i==1)
	    genosample[q].immanc = 2;
	  else
	    genosample[q].immanc = 1;
	}
	//genosample[q].immage = 0;
  	if (j<=25)
  	  {
  	    genosample[q].genotype[1][0] = 0;
  	    genosample[q].genotype[1][1] = 0;
  	  }
  	else if ((j > 25) && (j <= 75))
  	  {
  	    genosample[q].genotype[1][0] = 0;
  	    genosample[q].genotype[1][1] = 1;
  	  }
       else
  	  {
  	    genosample[q].genotype[1][0] = 1;
  	    genosample[q].genotype[1][1] = 1;
  	  }
       genochange[q].srcpop = genosample[q].srcpop;
       genochange[q].genotype[1][0] = genosample[q].genotype[1][0];
       genochange[q].genotype[1][1] = genosample[q].genotype[1][1];
       genochange[q].immanc = genosample[q].immanc;                // TEST
       genochange[q].immage = genosample[q].immage;                 // TEST
       //  examplefile << "Initial values for individual " << q << '\n';
       // examplefile << "source: " << genosample[q].srcpop << ", ancestry: " << genosample[q].immanc << ", age of ancestry: " << genosample[q].immage << '\n';
       //  examplefile << "genotype is " << genosample[q].genotype[1][0] << ", " << genosample[q].genotype[1][1] << '\n' << '\n';
       }      */
  
  /*  for (i=1; i<=numinds; ++i)
    {
      genosample[i].srcpop = 1;
      if (i<=20)
        {
	  genosample[i].immanc = 1;
	  genosample[i].immage = 0;
	  examplefile << "for individual " << i << ", srcpop is " << genosample[i].srcpop << ", immanc is " << genosample[i].immanc << ", immage is " << genosample[i].immage << '\n';
        }
      else if ((i > 20) && (i<=40))
        {
	  genosample[i].immanc = 2;
	  genosample[i].immage = 1;
        }
      else
        {
	  genosample[i].immanc = 2;
	  genosample[i].immage = 2;
        }
	}  */
  /*
  for(i=1;i<=numinds;i++)            // assign individual info
    {
      if((i==3)||(i==4))            // two individuals in 1 pop
	{
	  genosample[i].immanc=1;               // change to 1
	  genosample[i].srcpop=2;
	  genosample[i].immage=2;              // change to 2
	  genosample[i].genotype[1][0]=0;
	  genosample[i].genotype[1][1]=0;
	}
      else                         // rest in other pop
	{
	  genosample[i].immanc=1;
	  genosample[i].srcpop=1;
	  genosample[i].immage=0;
	  genosample[i].genotype[1][0]=0;
	  genosample[i].genotype[1][1]=1;
	}
      genochange[i].srcpop = genosample[i].srcpop;
      genochange[i].genotype[1][0] = genosample[i].genotype[1][0];
      genochange[i].genotype[1][1] = genosample[i].genotype[1][1];
      genochange[i].immanc = genosample[i].immanc;                  // TEST
      genochange[i].immage = genosample[i].immage;                 // TEST
    }
  */
  /*  for (i=1; i<=7; ++i)
    {
      genosample[i].immanc = 1;
      genosample[i].immage = 0;
    }
  for (i=8; i<=10; ++i)
    {
      genosample[i].immanc = 2;
      genosample[i].immage = 2;
    }
  genosample[8].immage = 1;
  for (i=11; i<=17; ++i)
    {
      genosample[i].immanc = 2;
      genosample[i].immage = 0;
    }
  for (i=18; i<=20; ++i)
    {
      genosample[i].immanc = 1;
      genosample[i].immage = 2;
    }
  genosample[18].immage = 1;
  for (i=1; i<=20; ++i)
    {
      genochange[i].immanc = genosample[i].immanc;
      genochange[i].immage = genosample[i].immage;
    }
  */
  // Generate initial values of immanc and immage randomly, based upon 
  //   initial values of m (maxminit)
 	
  for (i=1; i<=numinds; ++i)
    {
      r = 0;
      rvx = ran1(&idum);
      if (rvx <= 1.0 - (3.0*maxminit))
	{
	  genosample[i].immanc = genosample[i].srcpop;
	  genosample[i].immage = 0;
	  ++agecount[0];                // TEST
	}
      else
	for (j=1; j<=numpops; ++j)
	  {
	    if (j != genosample[i].srcpop)
	      {
		if (rvx > ((1.0 - (3.0 * maxminit)) + (((double)r * 3.0 * maxminit) / ((double)numpops - 1.0))))
		  genosample[i].immanc = j;
		++r;
	      }
	  }
      //  examplefile << "rvx for srcpop decision is " << rvx << '\n';
      if (genosample[i].srcpop != genosample[i].immanc)
	{
	  rvx = ran1(&idum);
	  //  examplefile << "rvx for anc decision is " << rvx << '\n';
	  if (rvx <=(1.0 / 3.0))
	    {
	    genosample[i].immage = 1;
	    ++agecount[1];                // TEST
	    }
          else
	    {
            genosample[i].immage = 2;
	    ++agecount[2];                   // TEST
	    }
	}
       genochange[i].srcpop = genosample[i].srcpop; 
       genochange[i].immanc = genosample[i].immanc;
       genochange[i].immage = genosample[i].immage; 
       //  examplefile << "Initial values for individual " << i << '\n';
       // examplefile << "source: " << genosample[i].srcpop << ", ancestry: " << genosample[i].immanc << ", age of ancestry: " << genosample[i].immage << '\n';
       // for (g=1; g<=marks; ++g)
	 // examplefile << "locus " << g << " has genotype " << genosample[i].genotype[g][0] << ", " << genosample[i].genotype[g][1] << '\n';
       // examplefile << '\n';
    } 
  /*        
  for(j=1;j<=numpops;j++)              // assign a uniform allele frequency
    {
      //  examplefile << "Population " << j << '\n';
    for(i=1;i<=numloci;i++)
      {
	//	examplefile << "Allele frequencies for locus " << i << '\n';
        for(k=0;k<numalleles[i];k++){
	  pmat[j][i][k]=1.0/(double)numalleles[i];
	  nextp[j][i][k] = pmat[j][i][k];
	  //  examplefile << "allele " << k << " has a frequency " << pmat[j][i][k] << '\n';
	  }
      }
    }
  */
    
  // Assign a uniform allele frequency    
  for (j=1; j<=numpops; ++j)
    {
      for (i=1; i<=numloci; ++i)
	{
	  while (1)
	    {
	      pmat[j][i][numalleles[i]-1] = 1.0;
	      for (k=0; k<((numalleles[i])-1); ++k)
		{
		  while (1)
		    {
		      rvx = ran1(&idum);
		      pmat[j][i][k] = rvx * 2.0 / double(numalleles[i]);
		      if (pmat[j][i][k] < minfreq)
			continue;
		      pmat[j][i][numalleles[i]-1] -= pmat[j][i][k];
		      break;
		    }
		}
	      if ((pmat[j][i][numalleles[i]-1] < minfreq) || (pmat[j][i][numalleles[i]-1] > ((2.0 / double(numalleles[i])))))
		continue;
	      break;
	    }
	}
    }
  
  allelesizemax = 0;
  allelesizemin = 1.0;  
  for (j=1; j<=numpops; ++j)
    {
      for (i=1; i<=numloci; ++i)
	{
          for (k=0; k<numalleles[i]; ++k)
	    {
	      nextp[j][i][k] = pmat[j][i][k];
	      //  examplefile << "POP: " << j << "  LOCUS: " << i << " ALLELE: " << k << " has a frequency of " << nextp[j][i][k] << '\n';
	      sumcheck += nextp[j][i][k];
	      if (pmat[j][i][k] < allelesizemin)
		allelesizemin = pmat[j][i][k];
	      if (pmat[j][i][k] > allelesizemax)
		allelesizemax = pmat[j][i][k];
	      //	      nextp[j][i][k] = pmat[j][i][k];
	    }  
	  // cout << "Sumcheck is " << sumcheck << '\n';
	  sumcheck = 0;
	}
      //  examplefile << '\n';
    }
  
  /* for (j=1; j <= numpops; ++j)
   {
     examplefile << "For population " << j << '\n';
     for (i=1; i <= numloci; ++i)
       {
         examplefile << "Locus " << i << '\n';
         for (k=0; k < numalleles[i]; ++k)
           {
             examplefile << "Allele " << k << ": pmat: " << pmat[j][i][k] << '\t' << "nextp: " << '\t' << nextp[j][i][k] << '\n';
           }
         examplefile << '\n';
       }
     examplefile << '\n';
     }*/
  // cout << "Minimum allele size is: " << allelesizemin << '\n';
  // cout << "Maximum allele size is: " << allelesizemax << '\n';
  // cout << "numloci is " << numloci << '\n';
  // cout << "Log 0 is " << log(0)*log(0)  << '\n';
  // cout << "Negative log is " << log(-5) << '\n';
  // cout << "Nan + value is " << log(-5) + 5 << '\n';
  // cout << "    numits is " << numits << '\n';
  /*
  for (i=1; i<=numinds; ++i)
    {
      cout << "Individual: " << i << '\n';
      for (k=1; k<=numloci; ++k)
	{
	  cout << "Locus: " << k << '\n';
          for (j=1; j<=numpops; ++j)
	    {
	      cout << "Population: " << j << '\n';
	      if ((genosample[i].immanc == genosample[i].srcpop) && ( genosample[i].srcpop == j))
	        if (genosample[i].genotype[k][0] == genosample[i].genotype[k][1])
	          {
		    cout << "Fvalue is: " << Fvalue[j] << ", and frequency of allele " << genosample[i].genotype[k][0] << " is " << pmat[j][k][genosample[i].genotype[k][0]] << '\n';
		    sumcheck = log(((1.0 - Fvalue[j]) * pow(pmat[j][k][genosample[i].genotype[k][0]], 2)) + Fvalue[j] * pmat[j][k][genosample[i].genotype[k][0]]);
		    cout << "   loglik is " << sumcheck << '\n';
		  }
	    }
	  cout << '\n';
	}
      cout << '\n';
    }
  */
  /*
  for (i=1; i<=numinds; ++i)
    {
      examplefile << "Is individual " << i << " missing data? " << indmissing[i] << '\n' << flush;
      if (indmissing[i] == 1)
        for (j=1; j<=numloci; ++j)
	  examplefile << "Missing at locus " << j << "?  " << datagone[i][j] << '\n' << flush;
    }
  examplefile << "Number of missing data: " << missingdata << '\n' << '\n' << flush;
  */

  // calculate the number of individuals in each population, and use this value to calculate gampopsum, the gamma of their sums
  for (i=1; i<=numinds; ++i)
    ++ popsums[genosample[i].srcpop];
  for (j=1; j<=numpops; ++j)
    gampopsum += gammln((float)popsums[j] + 1.0);

  //  cout << "log-L(M,t): " << loglikmtslow(anc, numinds,numpops,genosample,migmat) << "\n";
   cout << "log-L(M,t): " << loglikmt(anc, numinds, numpops, genosample, migmat, gampopsum) << '\n';
   //  examplefile << "anc is " << anc << ", numinds is " << numinds << ", numpops is " << numpops << '\n' << '\n';
   cout << "log-L(X): " << loglikgeno(numinds,numpops,numloci,genosample,migmat,pmat,Fvalue) << "\n";              // TEST

   //  for (j=0; j<3; ++j)
   //   examplefile << "number of times state " << j << " occurs is " << agecount[j] << '\n' << '\n'; 

  /*pmat[1][1][0] = 0.1;
 pmat[1][1][1] = 1.0 - pmat[1][1][0];
 pmat[2][1][0] = 0.6;
 pmat[2][1][1] = 1.0 - pmat[2][1][0];
 genosample[1].srcpop = 1;
 genosample[1].immanc = 1;
 genosample[1].immage = 0;
 genosample[2].srcpop = 1;
 genosample[2].immanc = 2;
 genosample[2].immage = 1;
 genosample[3].srcpop = 1;
 genosample[3].immanc = 2;
 genosample[3].immage = 2;
 genosample[4].srcpop = 1;
 genosample[4].immanc = 2;
 genosample[4].immage = 1;
 genosample[5].srcpop = 1;
 genosample[5].immanc = 2;
 genosample[5].immage = 2;
 genosample[1].genotype[1][0] = 0;
 genosample[1].genotype[1][1] = 0;
 genosample[2].genotype[1][0] = 0;
 genosample[2].genotype[1][1] = 1;
 genosample[3].genotype[1][0] = 0;
 genosample[3].genotype[1][1] = 1;
 genosample[4].genotype[1][0] = 0;
 genosample[4].genotype[1][1] = 1;
 genosample[5].genotype[1][0] = 0;
 genosample[5].genotype[1][1] = 0;
 examplefile << "loglikgeno is " << loglikgeno(numinds, numpops, numloci, genosample, migmat, pmat, Fvalue) << '\n';*/
  /* test code ends */

  /************************************************
   *  This next piece of code picks a value of    *
   *   pmat to change, changes it, and then       *
   *   determines if the new values are more or   *
   *   less probable.                             *
   ************************************************/


   likmtold = loglikmt(anc, numinds, numpops, genosample, migmat, gampopsum);
   likmtlarge = likmtold; 
   // likmtoldslow = loglikmtslow(anc, numinds, numpops, genosample, migmat);
   // likgenoldslow = loglikgeno(numinds, numpops, numloci, genosample, migmat, pmat, Fvalue);
   //  cout << "old loglik is " << likgenoldslow << '\n';
   for (i=1; i<=numinds; ++i)         // set initial values for indllgenos
     for (j=1; j<=numloci; ++j)
       {
         indllgenold[i][j] = indloglikgeno(i, j, genosample, migmat, pmat, Fvalue);
	 indllgennew[i][j] = indllgenold[i][j];
	 // examplefile << "indllgenold value for ind " << i << " at locus " << j << " is " << indllgenold[i][j] << '\n';
       }
   //  examplefile << '\n';
   likgenold = loglikgenosum(numinds, numloci, indllgenold);
   likgenolarge = likgenold;
   // cout << "new loglik is " << likgenold << '\n';
   if (Llvaluesrun == 1)
     examplefile << "Iteration" << '\t' << "L(M,t|m)" << '\t' << "L(X|S;M,t,F,p)" << '\n';


   long p;
   for (p=0; p<numits; ++p)     // is usually 3000000   
     {
       //       cout << "log - L(X): " << loglikgeno(numinds, numpops, numloci, genosample, migmat, pmat, Fvalue) << " at iteration " << p << '\n';

       if (Llvaluesrun == 1)
	 {
	   if (p == 0)
	     examplefile << p << '\t' << likmtold << '\t' << likgenold << '\n';
	   else if ((abs((likmtold - likmtlarge) >= 15.0)) || (abs((likgenold - likgenolarge) >= 30.0)))
	     {
	       examplefile << p << '\t' << likmtold << '\t' << likgenold << '\n';
	       likmtlarge = likmtold;
	       likgenolarge = likgenold;
	     }
	 }
       
     //  PUT ALL THIS BACK IN!!!!!!!!!       
     //  examplefile << '\n' << p << ", " << flush;
       //  examplefile << "ITERATION # " << p << '\n';
     if ((p % sampfreq) == 0)
	 {
	   //  examplefile << "Iteration number: " << p << '\n';
           cout << "This is iteration #" << p << '\n';
	   // examplefile << "  Loglikmt has a value of " << likmtold << '\n';
	   // examplefile << "  Loglikgeno has a value of " << likgenold << '\n';
	 }  

          // #ifdef CHARLIE
     rvx = ran1(&idum);                          // select a pop, locus, allele
  for (j=0; j<numpops; ++j)
    {
      if (rvx >= ((float)j / (float)numpops))
	cpop = j + 1;
    }
  //  examplefile << "First rvx in the loop is " << rvx << '\n';
  rvx = ran1(&idum);
  for (j=0; j<numloci; ++j)
    {
      if (rvx >= ((float)j / (float)numloci))
	cloc = j + 1;
    }
 rvx = ran1(&idum);
  for (j=0; j<numalleles[cloc]; ++j)
    {
      if (rvx >= ((float)j / (float)numalleles[cloc]))
	callele = j;             // because alleles start at 0
    }
  
  // if (cpop == 1)               // TEST
  // examplefile << "pop/locus/allele to change is " << cpop << "," << cloc << "," << callele << '\n';                   // TEST

  rvx = ran1(&idum);                            // alter the allele
  //  if (numalleles[cloc] < 10)
  modp = (rvx * 2.0 * deltap) - deltap;
    // else
    // modp = (rvx * 2.0 * (deltap * 10.0 / numalleles[cloc])) - (deltap * 10.0 / numalleles[cloc]);
  //  modp = (rvx * 2.0 * (deltap / numalleles[cloc])) - (deltap / numalleles[cloc]);
  //if (cpop == 1)
  // examplefile << "rvx for modp is " << rvx << " and modp is " << modp << '\n';
  while (1)
    {
      //  for (i=0; i < numalleles[cloc]; ++i)
      //	examplefile << "The frequency of allele " << i << " is " << pmat[cpop][cloc][i] << '\n';
      // examplefile << '\n';
      if (Fvalue[cpop] >= 0)
        {
      // if ((pmat[cpop][cloc][callele] + modp) < 0.0)
	  if ((pmat[cpop][cloc][callele] + modp) < minfreq)
            {
      //  if (cpop == 1)
      //examplefile << "                    pmat-modp is less than 0.  Bounce-back is occuring!!" << '\n';
	  //  nextp[cpop][cloc][callele] = (modp + pmat[cpop][cloc][callele]) * -1.0;
	      nextp[cpop][cloc][callele] = (2.0 * minfreq) - modp - pmat[cpop][cloc][callele];
	      //  examplefile << "pmat is " << pmat[cpop][cloc][callele] << ", cpop, cloc, allele are " << cpop << ", " << cloc << ", " << callele << '\n';
	      // examplefile << "minfreq is " << minfreq << ", and modp is " << modp << '\n';
	      //  examplefile << "nextp is " << nextp[cpop][cloc][callele] << '\n';
            }
          else if ((pmat[cpop][cloc][callele] + modp) > 1.0)
            {
      // if (cpop == 1)
      //examplefile << "                    pmat+modp is greater than 1.  Bounce-back is occuring!!" << '\n';
              nextp[cpop][cloc][callele] = 2.0 - (pmat[cpop][cloc][callele] + modp);
            }
          else
            nextp[cpop][cloc][callele] = pmat[cpop][cloc][callele] + modp;
	  
  // Adjust so sum to 1.
  //  For some reason (likely a rounding error), 1-freq(allele changed) did
  //  not equal sum(freq(alleles not changed)).  A possible solution to this 
  //  would be to force the allele frequencies to add to 1 by dividing them
  //  by their sum.
 
          sumallfreq = 0.0;       // adjust so sum to 1
          for (i=0; i<numalleles[cloc]; ++i)
            {
              if (i != callele)
	        sumallfreq += pmat[cpop][cloc][i];
            }
  //if (cpop == 1)
  //examplefile << "sumallfreq has a value of " << sumallfreq <<  '\n';  //TEST
          sumalleles = 0.0;           // TEST
	  sumallelesold = 0.0;
          if (sumallfreq == 0.0)                  // avoid division by 0
            {
              for (i=0; i<numalleles[cloc]; ++i)
	        {
	          if (i != callele)
	            nextp[cpop][cloc][i] = ((1.0 - nextp[cpop][cloc][callele]) / (numalleles[cloc] - 1.0));
	  //  if (cpop == 1)                 // TEST
	  //examplefile << "sumall freq is 0, pmat " << i << " is " << pmat[cpop][cloc][i] << " and nextp is " << nextp[cpop][cloc][i] << '\n';              // TEST
               }
	    }
	  else
            {
              for (i=0; i<numalleles[cloc]; ++i)
                {
                  if (i != callele)
	            {
	              if (sumallfreq < 0.05) 
	                nextp[cpop][cloc][i] = exp(log(pmat[cpop][cloc][i]) + log(1.0 - nextp[cpop][cloc][callele])- log(sumallfreq));
	              else
	                nextp[cpop][cloc][i] = ((pmat[cpop][cloc][i] * (1.0 - nextp[cpop][cloc][callele])) / sumallfreq);
	            }
	  // if (cpop == 1)               // TEST
		  //  examplefile << "pmat " << i << " is " << pmat[cpop][cloc][i] << " and nextp is " << nextp[cpop][cloc][i] << '\n';            // TEST
	          sumalleles += nextp[cpop][cloc][i];  // test, should equal 1
		  sumallelesold += pmat[cpop][cloc][i];
	        }
		}
  //if (cpop == 1)
	  //  examplefile << "Iteration is " << p << '\n';
	  // examplefile << "  sum of nextp's is " << sumalleles << ", and sum of pmats is " << sumallelesold << '\n' << '\n';
	}

      else
        {
	  // examplefile << "Minimum allowable allele frequency is " << Fvalue[cpop] / (Fvalue[cpop] - 1.0) << '\n';
	  if (((pmat[cpop][cloc][callele] + modp) < Fvalue[cpop] / (Fvalue[cpop] - 1.0)) || ((pmat[cpop][cloc][callele] + modp) < minfreq))
	    {
              if ((pmat[cpop][cloc][callele] + modp) < (Fvalue[cpop] / (Fvalue[cpop] - 1.0)))			// bruce changed 1 to 1.0 in denominator
	        nextp[cpop][cloc][callele] = 2.0 * (Fvalue[cpop] / (Fvalue[cpop] - 1.0)) - modp - pmat[cpop][cloc][callele];
	      else
		nextp[cpop][cloc][callele] = (2.0 * minfreq) - modp - pmat[cpop][cloc][callele];
	    }
          else if ((pmat[cpop][cloc][callele] + modp) > 1.0)
            nextp[cpop][cloc][callele] = 2.0 - (pmat[cpop][cloc][callele] + modp);
          else
            nextp[cpop][cloc][callele] = pmat[cpop][cloc][callele] + modp;
          sumallfreq = 0;
      // w = 0;
      // allelesizemin = 1.0;
          for (i=0; i<numalleles[cloc]; ++i)    // adjust so sum to 1
            {
	      if (i != callele)
	        sumallfreq += pmat[cpop][cloc][i];
	    }
          sumalleles = 0;     // TEST
	  sumallelesold = 0;
          if (sumallfreq == 0)
            {
              for (i=0; i < numalleles[cloc]; ++i)
                {
                  if (i != callele)
		    nextp[cpop][cloc][i] = ((1.0 - nextp[cpop][cloc][callele]) / (numalleles[cloc] - 1.0));
	        }
	    }
          else
	    {
	      for (i=0; i < numalleles[cloc]; ++i)
	        {
	          if (i != callele)
		    {
		      if (sumallfreq < 0.05)
		        nextp[cpop][cloc][i] = exp(log(pmat[cpop][cloc][i]) + log(1.0 - nextp[cpop][cloc][callele]) - log(sumallfreq));
		      else
		        nextp[cpop][cloc][i] = ((pmat[cpop][cloc][i] * (1.0 - nextp[cpop][cloc][callele])) / sumallfreq);
		    }
	          sumalleles += nextp[cpop][cloc][i];   // test, should be 1
		  sumallelesold += pmat[cpop][cloc][i];
	        }
 	    }
	//for (i=1; i<=numpops; ++i)
	  //	 {
	   // if (i == cpop)
	   // {
	   //   examplefile << "Population " << i << " was chosen" << '\n';
	   // }
	   //  else
	   //  examplefile << "Population " << i << '\n';
	   //  for (j=0; j<numalleles[cloc]; ++j)
	   //       examplefile << " Allele " << j << " has a frequency of " << pmat[i][cloc][j] << ", and a new frequency of " << nextp[i][cloc][j] << '\n';
	   // likgennewslow = loglikgeno(numinds, numpops, numloci, genosample, migmat, nextp, Fvalue);
	       //  examplefile << "Fvalue " << i << " is " << Fvalue[i] << '\n';
	   //	 }
	//	examplefile << "loglikgeno is " << likgennewslow << '\n';
	}
      w = 0;
      allelesizemin = 1.0;
      for (i=0; i < numalleles[cloc]; ++i)
        if (nextp[cpop][cloc][i] < allelesizemin)
          allelesizemin = nextp[cpop][cloc][i];
      // for (i=0; i < numalleles[cloc]; ++i)
      //	examplefile << "Proposed frequency for allele " << i << " is " << nextp[cpop][cloc][i] << '\n';
      // examplefile << '\n';
      if ((allelesizemin < (Fvalue[cpop] / (Fvalue[cpop] - 1.0))) || (allelesizemin < minfreq))
        {
           w = 1;
	   //   examplefile << "Proposed values are no good and are being rechosen" << '\n';
           rvx = ran1(&idum);
           modp = (rvx * 2.0 * deltap) - deltap;
        }
      if (w == 0)
        break;
    }     
 
        
  //  examplefile << "Out of the loop" << '\n' << '\n';

  // calculate alpha value, and use it to determine whether pmat
  // will change to nextp, or remain the same.  If log alpha>0, then
  // alpha>1, and we don't need to calculate it.  Nextp only changes if 
  // alpha<1

  // likgennewslow = loglikgeno(numinds, numpops, numloci, genosample, migmat, nextp, Fvalue);


  
  for (i=1; i<=numinds; ++i)
    {
      if (genosample[i].immage == 2)
        {
          if ((genosample[i].srcpop == cpop) || (genosample[i].immanc == cpop))
	    indllgennew[i][cloc] = indloglikgeno(i, cloc, genosample, migmat, nextp, Fvalue);
        }
      else
        if (genosample[i].immanc == cpop)
	  indllgennew[i][cloc] = indloglikgeno(i, cloc, genosample, migmat, nextp, Fvalue);
    }
  likgennew = loglikgenosum(numinds, numloci, indllgennew);
  alpha = likgennew - likgenold;
  

  //alpha = 2.0;


  // if ((p % 10000) == 0)
  // {
  //  examplefile << "VALUES FOR PMAT" << '\n';
  // examplefile << "likgenold slow is " << likgenoldslow << '\n';
  //  examplefile << "likgenold fast is " << likgenold << '\n';
  // examplefile << "likgennew slow is " << likgennewslow << '\n';
  // examplefile << "likgennew fast is " << likgennew << '\n' << '\n';
  // examplefile << " alpha is " << alpha << '\n';
  //  }
  //  examplefile << "Iteration " << p << '\n';
  // examplefile << "pmat value is " << likgenold << " and changed value is " << likgennew << '\n';
  if (alpha > 0)
    {
      alpha = 1.0;
      rvx = 0;
      //  if (cpop == 1)                // TEST
      //  examplefile << " alpha is greater than 0" << '\n';           // TEST
    }
   else
    {
     alpha = exp(alpha);
     rvx = ran1(&idum);
     //if (cpop == 1)               // TEST
     //  examplefile << "rvx is " << rvx << " and alpha is " << alpha << '\n';   // TEST
    }
  if (rvx <= alpha)
    {       
      //  if ((p % 10000) == 0)      
      //  examplefile << "pmat change was accepted" << '\n' << '\n';
      likgenold = likgennew;
      //  likgenoldslow = likgennewslow;
      ++pchange;
      ++pchange2[cloc];
      for (i=1; i<=numinds; ++i)
	indllgenold[i][cloc] = indllgennew[i][cloc];
      for(k=0;k<numalleles[cloc];++k)
        {
	  pmat[cpop][cloc][k] = nextp[cpop][cloc][k];
	  //  if (cpop == 1)
	  // examplefile << "pmat " << k << " is now " << pmat[cpop][cloc][k] << '\n';                 // TEST
	}
	//if (cpop == 1)
	//examplefile << '\n';             // TEST
    }

// Note: check this next bit.  It makes sense that it would be required, especially given the problems that arose in the next section, but it has yet to be used in this section.

  else
    {
      for (i=1; i<=numinds; ++i)
	indllgennew[i][cloc] = indllgenold[i][cloc];
      for (k=0; k<numalleles[cloc]; ++k)
	{
          nextp[cpop][cloc][k] = pmat[cpop][cloc][k];
	}
      //  if ((p % 10000) == 0)
      // examplefile << "pmat change was not accepted" << '\n' << '\n';
    }
  //  examplefile << '\n';

 // examplefile << "THIS IS THE END OF THIS RUN!!!" << '\n' << '\n' << '\n' << '\n';                     // TEST
 // for (k=0; k < numalleles[cloc]; ++k)
  // examplefile << "pmat " << k << " is now " << pmat[cpop][cloc][k] << '\n';
 //  }   // THIS IS TO MAKE THE PROGRAM ONLY RUN THE ALLELE FREQUENCY CHANGE.  REMOVE WHEN THIS WORKS!!!
 //#ifdef CHARLIE 
 
  /***********************************************
   *  This piece of code chooses a value of F    *
   *   to change, changes it, and then           *
   *   determines if the new value is more or    *
   *   less likely than the old one.             *
   ***********************************************/
      
     //   PUT ALL THIS BACK IN!!!!!!!!!!!!! 
 rvx = ran1(&idum);                // select a population
  for (j=0; j<numpops; ++j)
    {
      if (rvx >= ((float)j / (float)numpops))
	cpop = j+1;
    }

  allelesizemin = 1.0;
  for (i=1; i<=numloci; ++i)
    {
      for (k=0; k<numalleles[i]; ++k)
	{
	  if (pmat[cpop][i][k] < allelesizemin)
	    allelesizemin = pmat[cpop][i][k];
	}
    }

  //  for (i=1; i<=numpops; ++i)
  //  examplefile << "F value for population " << i << " is " << Fvalue[i] << '\n';
  rvx = ran1(&idum);          // alter the F value
  modF = (rvx * 2.0 * deltaF) - deltaF;
  if ((Fvalue[cpop] + modF) < (allelesizemin / (allelesizemin - 1.0)))
    {
      Fnew[cpop] = (2.0 * (allelesizemin / (allelesizemin - 1.0))) - modF - Fvalue[cpop];
      //  Fnew[cpop] = -2.0 - (Fvalue[cpop] + modF);  // if -1 was the bound
      //  examplefile << "BOUNCEBACK IS OCCURRING!!" << '\n';
      // examplefile << "lower bound is " << allelesizemin / (allelesizemin - 1.0) << '\n';
      // examplefile << "  original value of F was " << Fvalue[cpop] << ", modf is " << modF << " and new F is " << Fnew[cpop] << '\n';
    }
  else if ((Fvalue[cpop] + modF) > 1.0)
    {
      Fnew[cpop] = 2.0 - (Fvalue[cpop] + modF);
    }
  else
    Fnew[cpop] = Fvalue[cpop] + modF;
  // examplefile << "Fnew for population " << cpop << " is " << Fnew[cpop] << '\n';

  // calculate alpha value, and use it to determine whether Fvalue
  //  will change to Fnew, or remain the same.

  //  likgennewslow = loglikgeno(numinds, numpops, numloci, genosample, migmat, pmat, Fnew);
 

  
  for (i=1; i<=numinds; ++i)
    {
      if (genosample[i].immanc == cpop)
	if (genosample[i].immage <= 1)
	  for (j=1; j<=numloci; ++j)
	    indllgennew[i][j] = indloglikgeno(i, j, genosample, migmat, pmat, Fnew);
    }
  likgennew = loglikgenosum(numinds, numloci, indllgennew);
  alpha = likgennew - likgenold;
  

  //alpha = 2.0;


  //  if ((p % 100000) == 0)
  //  {
  // examplefile << "FVALUE CHANGES " << '\n';
  //  examplefile << "likgenold slow is " << likgenoldslow << '\n';
  // examplefile << "likgenold fast is " << likgenold << '\n';
  // examplefile << "likgennew slow is " << likgennewslow << '\n';
  //  examplefile << "likgennew fast is " << likgennew << '\n';
  // examplefile << " alpha is " << alpha << '\n';
  // }

  // examplefile << "Fvalue loglikmtslow is " << likgenold << " and changed value is " << likgennew << '\n';
  if (alpha > 0)
    {
      alpha = 1.0;
      rvx = 0;
    }
  else
    {
      alpha = exp(alpha);
      rvx = ran1(&idum);
    }
  // examplefile << "alpha is " << alpha << " and rvx is " << rvx << '\n';
  if (rvx <= alpha)
    {
      //      if ((p % 100000) == 0)      
      //  examplefile << "Fnew change was accepted" << '\n' << '\n';
      //  likgenoldslow = likgennewslow;
      likgenold = likgennew;
      for (i=1; i<=numinds; ++i)
	if (genosample[i].immanc == cpop)
	  if (genosample[i].immage <= 1)
	    for (j=1; j<=numloci; ++j)
	      indllgenold[i][j] = indllgennew[i][j];
      ++Fchange;
      Fvalue[cpop] = Fnew[cpop];
    }
  else
    {
      Fnew[cpop] = Fvalue[cpop];
      for (i=1; i<=numinds; ++i)
	if (genosample[i].immanc == cpop)
	  if (genosample[i].immage <= 1)
	    for (j=1; j<=numloci; ++j)
	      indllgennew[i][j] = indllgenold[i][j];
      //  if ((p % 100000) == 0)
      //  examplefile << "Fnew change was not accepted." << '\n' << '\n';
    }
  // examplefile << '\n';
 
  //#ifdef CHARLIE
  //#endif
  /**********************************************
   *  This piece of code chooses some missing   *
   *    data to change, changes it, and then    *
   *    determines if these new values are      *
   *    more or less likely than the old ones.  *
   **********************************************/
  //         PUT THIS BACK IN!!!!!!!!!!!!!!!!!!
  // if (p > 35975)
  //examplefile << '\n' << "ITERATION # " << p << '\n'; 
  if (missingdata > 0)
    {
      rvx = ran1(&idum);
      //  if (p > 35975)
      //examplefile << "rvx is " << '\t' << rvx << '\n';
      for (j=0; j<missingdata; ++j)
        {
          if (rvx >= ((float)j / (float)missingdata))
	    cmissingdata = j+1;
        }
      // if (p > 35975)
      //examplefile << "cmissingdata is " << cmissingdata << '\n';
      // examplefile << "cmissingdata is " << '\t' << cmissingdata << '\n';
      mcounter = 0;
      for (j=1; j<=numinds; ++j)
        if (indmissing[j] == 1)
          {
	    for (m=1; m<=numloci; ++m)
	      if (datagone[j][m] == 1)
	        {
	          ++mcounter;
	          if (mcounter == cmissingdata)
		    {
		      //if (p > 35975)
		      //examplefile << "Ind/locus to change is " << '\t' << j << '\t' << m << '\n';
		      for (i=0; i<=1; ++i)
		        {
		          rvx = ran1(&idum);
			  //  if (p > 35975)
			  //examplefile << "rvx " << i << " is " << rvx << '\n';
		          for (k=0; k<numalleles[m]; ++k)
		            {
			      if (rvx >= ((float)k / (float)numalleles[m]))
			        callele = k;
		            }
			  // if (p > 35975)
			  //examplefile << "New allele is " << '\t' << callele << '\n';
		          genochange[j].genotype[m][i] = callele;
			  // if (p > 35975)
			  //examplefile << "individual " << j << " now has allele " << genochange[j].genotype[m][i] << " at locus " << m << '\n';
		        }
		      indllgennew[j][m] = indloglikgeno(j, m, genochange, migmat, pmat, Fvalue);
		      //if (p > 35975)
		      //examplefile << "indllgennew for this ind/locus is " << '\t' << indllgennew[j][m] << '\n';
	              if ((genosample[j].genotype[m][0] == genosample[j].genotype[m][1]) && (genochange[j].genotype[m][0] != genochange[j].genotype[m][1]))
		        likdataadj = log(0.5);
                      else if ((genosample[j].genotype[m][0] != genosample[j].genotype[m][1]) && (genochange[j].genotype[m][0] != genochange[j].genotype[m][1]))
		        likdataadj = log(2.0);
                      else
		        likdataadj = 0;
		    }
	        }
          }



      
      //  likgennewslow = loglikgeno(numinds, numpops, numloci, genochange, migmat, pmat, Fvalue);
	likgennew = loglikgenosum (numinds, numloci, indllgennew);
	//if (p > 35975)
	//examplefile << "likgennew is then " << '\t' << likgennew << '\n';
	//	if ((p % 10000) == 0)
	//  {
	//  examplefile << "MISSINGDATA CHANGE" << '\n';
	//  examplefile << "likgennewslow is " << likgennewslow << '\n';
	// examplefile << "likgennew is " << likgennew << '\n';
	// examplefile << "likgenoldslow is " << likgenoldslow << '\n';
	// examplefile << "likgenold is " << likgenold << '\n' << '\n';
	//  }
        alpha = likgennew - likgenold + likdataadj;
	//examplefile << "alpha is " << '\t' << alpha << '\n';
	//if (p > 35975)
	//examplefile << "alpha is " << alpha << '\n';
	

	//  alpha = 2.0;




        if (alpha >= 0)
          {
	    alpha = 1;
	    rvx = 0;
          }
        else
          {
            rvx = ran1(&idum);
	    //  if (p > 35975)
	    //examplefile << "rvx is " << '\t' << rvx << '\n';
            alpha = exp(alpha);
          }
        mcounter = 0;
        if (alpha > rvx)
          {
	    // if (p > 35975)
	    //examplefile << "change is accepted" << '\t' << "1" << '\n';
	    //  likgenoldslow = likgennewslow;
	    likgenold = likgennew;
            for (j=1; j<=numinds; ++j)
              if (indmissing[j] == 1)
                for (m=1; m<=numloci; ++m)
	          if (datagone[j][m] == 1)
	            {
	              ++mcounter;
	              if (mcounter == cmissingdata)
	                {
			  indllgenold[j][m] = indllgennew[j][m];
		          genosample[j].genotype[m][0] = genochange[j].genotype[m][0];
		          genosample[j].genotype[m][1] = genochange[j].genotype[m][1];
		        }
		    }
          }
        else
          {
	    //if (p > 35975)
	    //examplefile << "change is not accepted" << '\t' << "0" << '\n';
	    for (j=1; j<=numinds; ++j)
	      if (indmissing[j] == 1)
	        for (m=1; m<=numloci; ++m)
	          if (datagone[j][m] == 1)
	            {
		      ++mcounter;
		      if (mcounter == cmissingdata)
		        {
			  indllgennew[j][m] = indllgenold[j][m];
		          genochange[j].genotype[m][0] = genosample[j].genotype[m][0];
		          genochange[j].genotype[m][1] = genosample[j].genotype[m][1];
		        }
		    }
          }
    //  for (i=1; i<=numloci; ++i)
    //  for (j=1; j<=numinds; ++j)
    //    examplefile << "genotype at locus " << i << " for individual " << j << " is " << genosample[j].genotype[i][0] << ", " << genosample[j].genotype[i][1] << '\n';
	//if (p > 35975)
	//examplefile << '\n';
    } 
  //#ifdef CHARLIE
  /***********************************************
   *  This piece of code chooses values of       *
   *   M and t to change, changes them, and      *
   *   then determines if these new values are   *
   *   more or less likely than the old ones.    *
   ***********************************************/
   
   // decided which individuals to change, and select new immanc, immage
  // for (p=0; p<3000; ++p)
  //  {
     //  examplefile << '\n';
     /*   for (i=1; i<=numinds; ++i)       // LEAVE THIS OUT!!!
       {
	 // examplefile << '\n';
	 rvx = ran1(&idum);
	 // examplefile << "individual " << i << " rvx for deltai is " << rvx << '\n';
	 if (rvx <= deltai)
	   {
	     //  examplefile << "srcpop is " << genosample[i].srcpop << ", immage is " << genosample[i].immage << ", and anc is " << genosample[i].immanc << '\n';
	     while (1)
	       {
		 w = 0;
		 rvx = ran1(&idum);
		 // examplefile << "rvx for cpop is " << rvx << '\n';
		 for (j=0; j<numpops; ++j)
		   if (rvx >= ((float)j / (float)numpops))
		     cpop = j+1;
		 // examplefile << "cpop is " << cpop << '\n';
		 rvx = ran1(&idum);
		 // examplefile << "rvx for immage is " << rvx << '\n';
		 genochange[i].immage = 1;
		 if (rvx <= 1.0/3.0)
		   genochange[i].immage = 0;
		 if (rvx > 2.0/3.0)
		   genochange[i].immage = 2;
		 // examplefile << "immage is " << genochange[i].immage << '\n';
		 if ((cpop == genosample[i].srcpop) && (genochange[i].immage != 0))
		   {
		     w = 1;
		     //  examplefile << "cpop = srcpop but immage != 0.  Choose again" << '\n';
		   }
		 if ((genochange[i].immage == 0) && (cpop != genosample[i].srcpop))
		   {
		     w = 1;
		     //  examplefile << "immage = 0 but cpop != srcpop.  Choose again" << '\n';
		   }
		 if (w == 0)
		   break;
	       }
	     genochange[i].immanc = cpop;
	   }
	   } */             // ALL OF THE ABOVE STAYS OUT!!!
	     //  examplefile << "proposed new state is: immage = " << genochange[i].immage << ", immanc = " << genochange[i].immanc << '\n' << '\n';
 
  rvx = ran1(&idum);                    // PUT THIS IN!!
     for (j=0; j<numinds; ++j)
       {
	 if (rvx >= ((float)j/(float)numinds))
	   cind = j+1;
       }
     //  examplefile << "cind is " << cind << '\n';
     //examplefile << "srcpop is " << genosample[cind].srcpop << " and immage is " << genosample[cind].immage << " and immanc is " << genosample[cind].immanc <<'\n';
     if (genosample[cind].srcpop == genosample[cind].immanc)
       {
	 // examplefile << "srcpop = immanc (1st piece of code)" << '\n';
	 rvx = ran1(&idum);
	 // examplefile << "rvx is " << rvx << '\n';
	 if (rvx <= 0.5)
	   genochange[cind].immage = 1;
         else
	   genochange[cind].immage = 2;
	 rvx = ran1(&idum);
	 for (j=0; j < (numpops - 1); ++j)
      	   {
       	     if (rvx > ((float)j/(float)(numpops - 1.0)))
               pop2change = j+1;
	   }
         if (pop2change >= genochange[cind].srcpop)
	   ++ pop2change;
	 genochange[cind].immanc = pop2change;
	 // examplefile << "change immage and immanc are " << genochange[cind].immage << " and " << genochange[cind].immanc << '\n' << '\n';
       }
     else
       {
	 // examplefile << "srcpop != immanc" << '\n';
         rvx = ran1(&idum);
	 // examplefile << "rvx to determine whether to choose 0 for immage is " << rvx << '\n';
       	 if (rvx <= 1.0 / (2.0 * (float)(numpops - 1.0)))
       	   {
             genochange[cind].immage = 0;
	     genochange[cind].immanc = genosample[cind].srcpop;
	     //  examplefile << "immage and immanc are now " << genochange[cind].immage << " and " << genochange[cind].immanc << " (should be a non-immigrant, 2nd piece of code)" << '\n' << '\n';
	   }
         else
       	   {
       	     while (1)
       	       {
       	         w = 0;
       	         rvx = ran1(&idum);
       	         for (j=0; j<numpops; ++j)
       		   if (rvx >= ((float)j / (float)numpops))
       		     cpop = j+1;
       	         if (cpop == genosample[cind].srcpop)
       		   {
       		     w = 1;
       		     continue;
       		   }
       	         rvx = ran1(&idum);
		 // examplefile << "rvx is " << rvx << '\n';
       	         if (rvx <= 0.5)
       		   genochange[cind].immage = 1;
                 else
       		   genochange[cind].immage = 2;
       	         if ((cpop == genosample[cind].immanc) && (genochange[cind].immage == genosample[cind].immage))
       		   w = 1;
       	         if (w == 0)
       		   break;
       	       }
       	 genochange[cind].immanc = cpop;
	 // examplefile << "immage and immanc are now " << genochange[cind].immage << " and " << genochange[cind].immanc << " (3rd piece of code)" << '\n' << '\n';
       	   }
	   }               // THE ABOVE IS THE PART TO KEEP

	     //	   }
	     //   }
     /*  for (i=1; i<=numchange; ++i)              // LEAVE THIS OUT
       {
	 cind[i] = 0;
	 while (1)
	   {
	     w = 0;
             rvx = ran1(&idum);
             for (j=0; j<numinds; ++j)
               if (rvx > ((float)j/(float)numinds))
	         cind[i] = j + 1;
	     for (k=1; k<i; ++k)
	       if (cind[i] == cind[k])
		 w = 1;
	     if (w == 0)
	       break;
	   }

	 // examplefile << "cind is " << cind << '\n';
     ++ numcind[cind];
     // examplefile << "  srcpop for this individual is " << genosample[cind].srcpop << ", immage is " << genosample[cind].immage << ", and immanc is " << genosample[cind].immanc << '\n';
     rvx = ran1(&idum);
     for (j=0; j<3; ++j)
       if (rvx > ((float)j/(3.0)))
	 {
	   // examplefile << "rvx is " << rvx << " and j is " << j << '\n';
	 genochange[cind].immage = j;
	 }
     ++ anccount[genochange[cind].immage];
     if (genochange[cind].immage == 0)
       genochange[cind].immanc = genosample[cind].srcpop;
     else
       {
	 rvx = ran1(&idum);
	 for (j=0; j<(numpops-1); ++j)
	   {
	     // examplefile << "we go through this loop " << j << " times" << '\n';
	     if (rvx > ((float)j/(float)(numpops - 1.0)))
	       pop2change = j+1;
	   }
	 if (pop2change >= genochange[cind].srcpop)
	   ++ pop2change;
	 if (pop2change > numpops)
	   pop2change = 1;
	 genochange[cind].immanc = pop2change;
       }
     //  examplefile << "  change srcpop for cind is " << genochange[cind].srcpop << "  immage is " << genochange[cind].immage << " and immanc is " << genochange[cind].immanc << '\n';
     ++ numcpop[genochange[cind].immanc];
     }  */                       // LEAVE THE ABOVE OUT

 // for looking at population values at each iteration
     
   for (i=1; i<=numpops; ++i)        // PUT THIS IN!!!
       for (j=1; j<=numpops; ++j)
	 for (k=0; k<=2; ++k)
	   pophists[i][j][k] = 0;
     for (i=1; i<=numinds; ++i)
       ++ pophists[genosample[i].srcpop][genosample[i].immanc][genosample[i].immage];
     //   for (i=1; i<=numpops; ++i)
     //  {
     //	 examplefile << "Genosample for population " << i << ": " << '\n';
     //	 for (j=1; j<=numpops; ++j)
     //   for (k=0; k<=2; ++k)
     //     examplefile << "# of times assigned to pop " << j << " at time " << k << " is " << pophists[i][j][k] << '\n';
     //     examplefile << '\n';
     //  }  

     for (i=1; i<=numpops; ++i)
      for (j=1; j<=numpops; ++j)
        for (k=0; k<=2; ++k)
          pophistc[i][j][k] = 0;
     for (i=1; i<=numinds; ++i)
       ++ pophistc[genochange[i].srcpop][genochange[i].immanc][genochange[i].immage];

     //   for (i=1; i<=numpops; ++i)
     //  {
     // examplefile << "Genochange for population " << i << ": " << '\n';
     // for (j=1; j<=numpops; ++j)
     //   for (k=0; k<=2; ++k)
     //     examplefile << "# of times assigned to pop " << j << " at time " << k << " is " << pophistc[i][j][k] << '\n';
     //     examplefile << '\n';
     //     }




    
     
     for (i=1; i<=numpops; ++i)
       for (k=0; k<=2; ++k)
	 pophistage[i][k] = 0;
     for (k=0; k<=2; ++k)
       for (i=1; i<=numpops; ++i)
	 for (j=1; j<=numpops; ++j)
	   pophistage[i][k] += pophists[i][j][k];

     for (j=1; j<=numloci; ++j)
       indllgennew[cind][j] = indloglikgeno(cind, j, genochange, migmat, pmat, Fvalue);
     likgennew = loglikgenosum(numinds, numloci, indllgennew);


     // derive an alpha value, and determine whether to accept the change
     //     examplefile << "Results for the M, t alteration." << '\n';
     // likmtnewslow = loglikmtslow(anc, numinds, numpops, genochange, migmat);
     // examplefile << "M, t likmtnewslow is " << likmtnewslow << '\n';
     likmtnew = loglikmt(anc, numinds, numpops, genochange, migmat, gampopsum);
     // examplefile << "M, t likmtnew is " << likmtnew << '\n' << '\n';
     //  likgennewslow = loglikgeno(numinds, numpops, numloci, genochange, migmat, pmat, Fvalue);

     alpha = likmtnew + likgennew - likmtold - likgenold + logprMadj(cind, pophists, genosample, genochange);
     

     //alpha = 2.0;




										       // alpha = likmtnew - likmtold + logprMadj(cind, pophists, genosample, genochange);                   // TAKE THIS OUT!!!!

     // alpha = loglikgeno(numinds, numpops, numloci, genochange, migmat, pmat) - loglikgeno(numinds, numpops, numloci, genosample, migmat, pmat, Fvalue);
     //     alpha = loglikgeno(numinds, numpops, numloci, genochange, migmat, pmat, Fvalue) + loglikmt(anc, numinds, numpops, genochange, migmat) - loglikgeno(numinds, numpops, numloci, genosample, migmat, pmat, Fvalue) - loglikmt(anc, numinds, numpops, genosample, migmat) + logprMadj(cind, pophistage, genosample, genochange);
     //  examplefile << "loglikmtslow for sample is " << likmtold << " and for change is " << likmtnew << '\n';
     //  if ((p % 100000) == 0)
     //{
     // examplefile << " p is " << p << '\n';
     //  examplefile << "M, T CHANGES " << '\n';
     // examplefile << "likmtnewslow is " << likmtnewslow << '\n';
     // examplefile << "likmtnew is " << likmtnew << '\n' <<'\n';
     //  examplefile << "loglikgeno for sample is " << likgenoldslow << " and for change is " << likgennewslow << '\n';
     // examplefile << "loglikgeno fast for sample is " << likgenold << " and for change is " << likgennew << '\n' <<'\n';
     //  }  
     // examplefile << "logprMadj is " << logprMadj(cind, pophistage, genosample, genochange) << '\n';
     // examplefile << "alpha value is " << alpha << '\n';

     if (alpha >= 0)
       {
	 alpha = 1;
	 rvx = 0;
	 // examplefile << "alpha is greater than 0" << '\n';
       }
     else
       {
	 rvx = ran1(&idum);
	 alpha = exp(alpha);
	 // examplefile << "rvx has a value of " << rvx << " and alpha is " << alpha << '\n';
       }
     if (alpha > rvx)
       {
	 // likgenoldslow = likgennewslow;
	 likgenold = likgennew;
	 likmtold = likmtnew;
	 // likmtoldslow = likmtnewslow;
	 for (j=1; j<=numloci; ++j)
	   indllgenold[cind][j] = indllgennew[cind][j];
	 for (i=1; i<=numinds; ++i)
	   {
	     genosample[i].immanc = genochange[i].immanc;
	     genosample[i].immage = genochange[i].immage;
	     // ++ancaccept[genochange[i].immage];
	   }
	 // examplefile << "CHANGE IS ACCEPTED" << '\n';
       }
     else
       {
	 for (j=1; j<=numloci; ++j)
	   indllgennew[cind][j] = indllgenold[cind][j];
	 for (i=1; i<=numinds; ++i)
	   {
	     genochange[i].immanc = genosample[i].immanc;
	     genochange[i].immage = genosample[i].immage;
	   }
	 // examplefile << "CHANGE IS NOT ACCEPTED" << '\n';
       }
     //  examplefile << '\n';
   if (p == 0)
     {
       maxlog = likmtold;
       minlog = likmtold;
     }
   else
     {
       if (likmtold > maxlog)
        maxlog = likmtold;
       if (likmtold < minlog)
        minlog = likmtold;
     } 

   //  examplefile << "srcpop for cind is now " << genosample[cind].srcpop << ", immanc is " << genosample[cind].immanc << ", and immage is " << genosample[cind].immage << '\n' << '\n';
   
   // examplefile << "settings for individuals are now: " << '\n';
   // for (i=1; i<=numinds; ++i)
   //  examplefile << "Individual " << i << ": srcpop is " << genosample[i].srcpop << ", immanc is " << genosample[i].immanc << " and age is " << genosample[i].immage << '\n';

   //  for (i=1; i<=numpops; ++i)
   // for (k=0; k<=2; ++k)
   //   examplefile << "pophistage " << i << ", " << k << " is " << pophistage[i][k] << '\n';

     // sample values from the chain

   //   }   //  THIS IS JUST TO CHECK THIS SECTION
   
  /************************************************
   *  This next piece of code picks a value of    *
   *   migmat to change, changes it, and then     *
   *   determines if the new values are more or   *
   *   less probable.                             *
   ************************************************/
   
   //  for (p=0; p<10; ++p)
   //  {                // TEST
   if (numpops == 2)
     {
       rvx = ran1(&idum);
       if (rvx <= 0.5)
	 cpopb = 1;
       else
	 cpopb = 2;
       rvx = ran1(&idum);
       modm = (rvx * 2.0 * deltam) - deltam;
       if ((migmat[cpopb][cpopb] + modm) <= (2.0 / 3.0))
	 {
	   cmigmat[cpopb][cpopb] = (modm + migmat[cpopb][cpopb]) * -1.0 + (2.0 * (2.0 / 3.0));
	 }
       else if ((migmat[cpopb][cpopb] + modm) > (1.0 - minfreq))
	 {
	   cmigmat[cpopb][cpopb] = 2.0 * (1.0 - minfreq) - (migmat[cpopb][cpopb] + modm);
	 }
       else
	 cmigmat[cpopb][cpopb] = migmat[cpopb][cpopb] + modm;
       for (i=1; i <= numpops; ++i)
	 if (i != cpopb)
	   cmigmat[i][cpopb] = 1.0 - cmigmat[cpopb][cpopb];
     }

   else
     {
       rvx = ran1(&idum);                          // select the to and from pops
       for (j=0; j<numpops; ++j)
         {
           if (rvx >= ((float)j / (float)numpops))
	     cpop = j + 1;
         }
       rvx = ran1(&idum);
       for (j=0; j<numpops; ++j)
         {
           if (rvx >= ((float)j / (float)numpops))
	     cpopb = j + 1;
         }
     //     if (cpopb == 2)
     // {
     //  cout << "cpop is " << cpop << " and cpopb is " << cpopb << '\n';//TEST
     // for (i=1; i<=numpops; ++i)
     // examplefile << "current value of m from population " << i << " to population " << cpopb << " is " << migmat[i][cpopb] << '\n';      // TEST
     //  }
     while (1)
       {
         if (cpop == cpopb)
           {
             rvx = ran1(&idum);                            // alter m
             modm = (rvx * 2.0 * deltam) - deltam;
         //  if (cpopb == 2)
         //  examplefile << "rvx for modm is " << rvx << " and modm is " << modm << '\n';         // TEST
             if ((migmat[cpop][cpopb] + modm) <= (2.0 / 3.0))
               {
	     // if (cpopb == 2)
	     // examplefile << "                    migmat-modm is less than 0.  Bounce-back is occuring!!" << '\n';
	         cmigmat[cpop][cpopb] = (modm + migmat[cpop][cpopb]) * -1.0 + (2.0 * (2.0 / 3.0));
               }
	     //  else if ((migmat[cpop][cpopb] + modm) > 1.0)   // must be changed
	     else if ((migmat[cpop][cpopb] + modm) > (1.0 - (((double)numpops - 1.0) * minfreq)))
               {
	     // if (cpopb == 2)
	     //  examplefile << "                   migmat + modp is greater than 1.  Bounce-back is occuring!!" << '\n';
		 cmigmat[cpop][cpopb] = 2.0 * (1.0 - (((double)numpops - 1.0) * minfreq)) - (migmat[cpop][cpopb] + modm);
	     //    cmigmat[cpop][cpopb] = 2.0 - (migmat[cpop][cpopb] + modm);
               }
             else
               cmigmat[cpop][cpopb] = migmat[cpop][cpopb] + modm;

         // Adjust so sum to 1

             summadj = 0.0;
             for (i=1; i<=numpops; ++i)
               {
	         if (i != cpop)
	           summadj += migmat[i][cpopb];
               }
         //   if (cpopb == 2)
         //  examplefile << "summadj has a value of " << summadj << '\n';
             summ = 0.0;
	     sumallelesold = 0.0;
             if (summadj == 0.0)      // avoid division by zero
               {
	         for (i=1; i<=numpops; ++i)
	           {
	             if (i != cpop)
	               cmigmat[i][cpopb] = ((1.0 - cmigmat[cpop][cpopb]) / (numpops - 1.0));
	         //   if (cpopb == 2)
	         //  examplefile << "summadj is 0, migmat " << i << " is " << migmat[i][cpopb] << " and cmigmat is " << cmigmat[i][cpopb] << '\n';
	           }
               }
             else
               {
	         for (i=1; i<=numpops; ++i)
	           {
	             if (i != cpop)
	               {
		         if (summadj < 0.05)
		           cmigmat[i][cpopb] = exp(log(migmat[i][cpopb]) + log(1.0 - cmigmat[cpop][cpopb]) - log(summadj));
                         else
		           cmigmat[i][cpopb] = (migmat[i][cpopb] * (1.0 - cmigmat[cpop][cpopb])) / summadj;
	               }
	         //  if (cpopb == 2)
		     //   examplefile << "migmat " << i << " is " << migmat[i][cpopb] << " and cmigmat is " << cmigmat[i][cpopb] << '\n';
		     //      summ += cmigmat[i][cpop];    // Test, should equal 1
		     //  sumalleles += migmat[i][cpop];
	           }
               }
     //   if (cpopb == 2)
	     //    examplefile << "sum of cmigmat's is " << summ << ", and migmat's is " << sumallelesold << '\n';
	   }
         else
           {
	     rvx = ran1(&idum);
	     // if (migmat[cpopb][cpopb] >= (1.0 - deltaminit))    // adjust deltam so modm doesn't reflect more than once
	     if (migmat[cpopb][cpopb] >= ((1.0 - (minfreq * ((double)numpops - 2.0))) - deltaminit))
	       deltam = (1.0 - (minfreq * ((double)numpops - 2.0))) - migmat[cpopb][cpopb];
	       // deltam = 1.0 - migmat[cpopb][cpopb];
	     modm = (rvx * 2.0 * deltam) - deltam;
	     if ((migmat[cpop][cpopb] + modm) < minfreq)
	       {
		 // cmigmat[cpop][cpopb] = (migmat[cpop][cpopb] + modm) * -1.0;
		 cmigmat[cpop][cpopb] = (2.0 * minfreq) - modm - migmat[cpop][cpopb];
	     //   if ((p % 100000) == 0)
	     //  {
	     // examplefile << "MIGMAT IS < 0!!" << '\n';
	     // examplefile << "migmat is " << migmat[cpop][cpopb] << ", and cmigmat is " << cmigmat[cpop][cpopb] << '\n';
	     //  }
	       }
	     //  else if ((migmat[cpop][cpopb] + modm) >= (1.0 - migmat[cpopb][cpopb]))
	     else if ((migmat[cpop][cpopb] + modm) >= ((1.0 - (((double)numpops - 2.0) * minfreq)) - migmat[cpopb][cpopb]))
	       {
		 cmigmat[cpop][cpopb] = (2.0 * ((1.0 - (((double)numpops - 2.0) * minfreq)) - migmat[cpopb][cpopb])) - (migmat[cpop][cpopb] + modm);
		 // cmigmat[cpop][cpopb] = (2.0 * (1.0 - migmat[cpopb][cpopb])) - (migmat[cpop][cpopb] + modm);
	     //  if ((p % 100000) == 0)
	     //  {
	     // examplefile << "MIGMAT IS TOO LARGE!!" << '\n';
	     //  examplefile << "migmat is " << migmat[cpop][cpopb] << ", and cmigmat is " << cmigmat[cpop][cpopb] << '\n';
	     //  }
	       }  
	     else
	       {
	         cmigmat[cpop][cpopb] =  migmat[cpop][cpopb] + modm;
	     //  if ((p % 100000) == 0)
	     //  {
	     // examplefile << "MIGMAT DOES NOT NEED ADJUSTMENT" << '\n';
	     //  examplefile << "migmat is " << migmat[cpop][cpopb] << ", and cmigmat is " << cmigmat[cpop][cpopb] << '\n';
	     //  }	       
	       }

	 // adjust so sum to 1
	     //   if (numpops == 2)
	     //  cmigmat[cpopb][cpopb] = 1.0 - cmigmat[cpop][cpopb];
	     //  else
	         summadj = 0.0;
	         for (i=1; i <= numpops; ++i)
	           if ((i != cpop) && (i != cpopb))
	             summadj += migmat[i][cpopb];
	         if (summadj < 0.05)
	           adjconst = exp(log(1.0 - migmat[cpopb][cpopb] - cmigmat[cpop][cpopb]) - log(summadj));
	         else
	           adjconst = (1.0 - migmat[cpopb][cpopb] - cmigmat[cpop][cpopb]) / summadj;
	         for (i=1; i <= numpops; ++i)
	           if ((i != cpop) && (i != cpopb))
	             if (summadj < 0.05)
		       cmigmat[i][cpopb] = exp(log(migmat[i][cpopb]) + log(adjconst));
	             else
	               cmigmat[i][cpopb] = migmat[i][cpopb] * adjconst;
	         cmigmat[cpopb][cpopb] = migmat[cpopb][cpopb];
           }
	 w = 0;
	 migsizemin = 1.0;
	 migsizemax = 0;
	 for (i=1; i<=numpops; ++i)
	   if (i != cpopb)
	     {
	       if (cmigmat[i][cpopb] < migsizemin)
	         migsizemin = cmigmat[i][cpopb];
	       //  if (cmigmat[i][cpopb] >= ((1.0 - (((double)numpops - 2.0) * minfreq)) - migmat[cpopb][cpopb]))
	       // migsizemax = cmigmat[i][cpopb];
	     }
	 if (migsizemin < minfreq)
	   w = 1;
	 if (w == 0)
	   break;
       }
     }
     // examplefile << '\n';
     // examplefile << "Deltam is " << deltam << ", deltaminit is " << deltaminit << ", and modm is " << modm << '\n';
   //     summ = 0.0;
   // sumallelesold = 0.0;
     // cout << "cpop is " << cpop << " and cpopb is " << cpopb << '\n';
   // for (i=1; i<=numpops; ++i)
   //  {
	 //  cout << "migmat[" << i << "][" << cpopb << "] is " << migmat[i][cpopb] << " and cmigmat is " << cmigmat[i][cpopb] << '\n';
   // summ += cmigmat[i][cpopb];
   // sumallelesold += migmat[i][cpopb];
   //  }
     //  cout << "sum of migmats is " << sumallelesold << ", and sum of cmigmats is " << summ << '\n' << '\n';
     //  for (i=1; i<=numpops; ++i)
     //  examplefile << "cmigmat[" << i << "][" << cpopb << "] is " << cmigmat[i][cpopb] << '\n';     

	 /*                 LEAVE THIS OUT!!!!!
	 if ((migmat[cpop][cpopb] + modm) < 0.0)
	   cmigmat[cpop][cpopb] = (modm + migmat[cpop][cpopb]) * -1.0;
	 else if ((migmat[cpop][cpopb] + modm) > (1.0 / 3.0))
	   cmigmat[cpop][cpopb] = 2.0 * (1.0 / 3.0) - (migmat[cpop][cpopb] + modm);
	 else
	   cmigmat[cpop][cpopb] = migmat[cpop][cpopb] + modm;

	 // Adjust so sum to one

	 for (i=1; i <= numpops; ++i)
	   if (i != cpopb)
	     if (i == cpop)
	       {
		 if ((1.0 - migmat[cpopb][cpopb] + modm) < 0.05)
		   cmigmat[i][cpopb] = exp(log(cmigmat[i][cpopb]) + log(1.0 - migmat[cpopb][cpopb]) - log(1.0 - migmat[cpopb][cpopb] + modm));
		 else
		   cmigmat[i][cpopb] = cmigmat[i][cpopb] * (1.0 - migmat[cpopb][cpopb]) / (1.0 - migmat[cpopb][cpopb] + modm);
	       }
	     else
	       {
		 if ((1.0 - migmat[cpopb][cpopb] + modm) < 0.05)
		   cmigmat[i][cpopb] = exp(log(migmat[i][cpopb]) + log(1.0 - migmat[cpopb][cpopb]) - log(1.0 - migmat[cpopb][cpopb] + modm));
		 else
		   cmigmat[i][cpopb] = migmat[i][cpopb] * (1.0 - migmat[cpopb][cpopb]) / (1.0 - migmat[cpopb][cpopb] + modm);
	       }
       }
	 */     // THIS PART GETS LEFT OUT!!!!!

  // calculate alpha value, and use it to determine whether migmat
  // will change to cmigmat, or remain the same.  If log alpha>0, then
  // alpha>1, and we don't need to calculate it.  Cmigmat only changes if 
  // alpha<1
  
     //  examplefile << "Results for the migration rate alteration" << '\n';
     // likmtnewslow = loglikmtslow(anc, numinds, numpops, genosample, cmigmat);




   
    likmtnew = loglikmt(anc, numinds, numpops, genosample, cmigmat, gampopsum);
    alpha = likmtnew - likmtold;
   

    //alpha = 2.0;




    //  examplefile << "likmtnewslow for changing m is " << likmtnewslow << '\n';
    //  examplefile << "likmtnew is " << likmtnew << " and likmtold is " << likmtold << '\n';
    // examplefile << "  alpha is " << alpha << '\n';
     //  examplefile << "loglikmtslow for the migration rate is " << likmtold << " and for change is " << likmtnew << '\n';
     // Do we need the piece of code below??
     //  if (cmigmat[cpopb][cpopb] < (1.0 - (1.0 / ((pow(2.0, (double)anc) - 1.0)-1.0))))
     //  {
     //  examplefile << "cmigmat " << cpopb << " is " << cmigmat[cpopb][cpopb] << '\n';
     //  alpha = -999;    // test to make sure that number of first and second generation immigrants is less than 1
	 // note: is this symmetrical?
     //  }
     if (alpha >= 0)
       {
         alpha = 1.0;
         rvx = 0;
	 //	 if (cpopb == 2)
	 // examplefile << " alpha is greater than 0" << '\n';
       }
     //    else if (alpha == -999)
     //  {
     //	 rvx = 0.0;
	 // if (cpopb == 2)
	 // {
	 //  examplefile << "    alpha is -999" << '\n';
	 //  examplefile << "    test variable is " << pow(2.0, (double)anc - 1.0) - 1.0 << '\n';
	 // }
     //  }
     else
       {
         alpha = exp(alpha);
         rvx = ran1(&idum);
	 //	 if (cpopb == 2)
	 // examplefile << "rvx is " << rvx << " and alpha is " << alpha << '\n';
       }
     //  examplefile << "rvx for migmat is " << rvx << '\n';

     /*  if ((p%100000) == 0)        LEAVE THIS OUT!!!!!!!!
      {
	examplefile << "m CHANGES" << '\n';
	examplefile << "Alpha is " << alpha << '\n';
	examplefile << "likmtold is " << likmtold << '\n';
	examplefile << "likmtnewslow is " << likmtnewslow << '\n';
	examplefile << "likmtnew is " << likmtnew << '\n';
	examplefile << "The changed migmat is " << cpop << ", " << cpopb << '\n';
	examplefile << " It is modified by " << modm << '\n' << '\n';
	for (i=1; i <= numpops; ++i)
	  examplefile << "migmat " << i << ", " << cpopb << " is " << migmat[i][cpopb] << '\n';
	examplefile << '\n';
	for (i=1; i <= numpops; ++i)
	  examplefile << "cmigmat is " << i << ", " << cpopb << " is " << cmigmat[i][cpopb] << '\n';
	examplefile << '\n'; 
	//	if (cmigmat[cpopb][cpopb] < 0.7)
	//  examplefile << "LOW Mii VALUE IS " << cmigmat[cpopb][cpopb] << '\n';
	if (rvx <= alpha)
	  examplefile << "  migmat is changed" << '\n' << '\n';
        else
	  examplefile << "  migmat is not changed" << '\n' << '\n';
	  }    */     // THIS GETS LEFT OUT!!!!

  
     if (rvx <= alpha)
       {
	 likmtold = likmtnew;
	 // likmtoldslow = likmtnewslow;
	 ++mchange;
	 // if ((p%10000) == 0)
	 // examplefile << "migmat is changed" << '\n' << '\n';
	 //	 likgenoldslow = loglikgeno(numinds, numpops, numloci, genosample, migmat, pmat, Fvalue);
         for(k=1;k<=numpops;++k)
           {
	     migmat[k][cpopb] = cmigmat[k][cpopb];
	     //  if (cpopb == 2)
	     //  examplefile << "migmat " << k << " is now " << migmat[k][cpopb] << '\n';
	   }
	 // examplefile << "migmat is changed" << '\n';
       }
     else
       {
	 // if ((p%10000) == 0)
	 //  {
	 // examplefile << "migmat is not changed" << '\n';
	 //    for (k=1; k<=numpops; ++k)
	 //      examplefile << "cmigmat from " << k << " to " << cpopb << " is " << cmigmat[k][cpopb] << '\n';
	 //    examplefile << '\n';
	 //  }
	 for (k=1; k<=numpops; ++k)
	   cmigmat[k][cpopb] = migmat[k][cpopb];
       }
     deltam = deltaminit;         // reset deltam
     //  examplefile << "PART WHERE m CHANGES.  NOTE: THIS IS AFTER LIKGEN IS RECALCULATED" << '\n';
     //  examplefile << "likgenoldslow is " << likgenoldslow << '\n';
     //  examplefile << "likgenold is " << likgenold << '\n' << '\n';
     //  examplefile << '\n' << '\n';
     
     // #endif
     /*************************************************
      *  Collect summary data for all manipulations   *
      *************************************************/
        
     if (p > burnin)     // PUT BACK IN!!!!!!!!
      {
	if ((p % sampfreq) == 0)      // PUT BACK IN!!!!!!!!!!
        {
	  // examplefile << pmat[1][2][0] << '\n';
	  
	  prob0 = 0;
	  prob1 = 0;
	  prob2 = 0;
	  //  for (i=1; i<=numinds; ++i)
	  // if (genosample[i].srcpop == 5)
	  //  {
	  //    if (genosample[i].immage == 0)
	  //  ++ prob0;
	  //else if (genosample[i].immage == 1)
	  //  ++ prob1;
	  //else if (genosample[i].immage == 2)
	  //  ++ prob2;
	  //  }
	  //  examplefile << prob0 << '\t' << prob1 << '\t' << prob2 << '\n';
	 
	 ++ counter;
         for (i=1; i<=numpops; ++i)
           for (j=1; j<=numloci; ++j)
	     for (k=0; k<numalleles[j]; ++k)
	       {
		 if (pmat[i][j][k] < 0 || pmat[i][j][k] > 1.0)
		   examplefile << "pmat is not bound between 0 and 1." << '\n' << flush;
	         for (m=1; m<=numdivsp; ++m)
	           {
	             bounda = float(m - 1) / float(numdivsp);
	             boundb = float(m) / float(numdivsp);
	             if ((bounda <= pmat[i][j][k]) && (pmat[i][j][k] < boundb))
		       ++ allfreqhis[i][j][k][m];
 	           }
	         if (pmat[i][j][k] == 1.0)
	           ++ allfreqhis[i][j][k][numdivsp];
		 meannew[i][j][k] = meanold[i][j][k] + ((pmat[i][j][k] - meanold[i][j][k]) / float(counter));
		 if (counter >= 2)
		   varnew[i][j][k] = ((1.0 - (1.0 / (float(counter) - 1.0))) * varold[i][j][k]) + (float(counter) * (meannew[i][j][k] - meanold[i][j][k]) * (meannew[i][j][k] - meanold[i][j][k]));
		 meanold[i][j][k] = meannew[i][j][k];
		 varold[i][j][k] = varnew[i][j][k];
 	       }
	 for (i=1; i<=numpops; ++i)
	   {
	     if ((Fvalue[i] < -1.0) || (Fvalue[i] > 1.0))
	       {
	         examplefile << "Fvalue is not bound between -1 and 1." << '\n' << flush;
		 examplefile << "  population " << i << " has an Fvalue of " << Fvalue[i] << '\n';
	       } 
	     for (m=(-numdivsF+1); m<=numdivsF; ++m)
	       {
		 bounda = float(m-1) / float(numdivsF);
		 boundb = float(m) / float(numdivsF);
		 if ((bounda <= Fvalue[i]) && (Fvalue[i] < boundb))
		   ++ Ffreqhis[i][m];
	       }
	     if (Fvalue[i] == 1.0)
	       ++ Ffreqhis[i][numdivsF];
	     meannewF[i] = meanoldF[i] + ((Fvalue[i] - meanoldF[i]) / float(counter));
	     if (counter >=2)
	       varnewF[i] = ((1.0 - (1.0 / (float(counter) - 1.0))) * varoldF[i]) + (float(counter) * (meannewF[i] - meanoldF[i]) * (meannewF[i] - meanoldF[i]));
	     meanoldF[i] = meannewF[i];
	     varoldF[i] = varnewF[i];
	   }

         for (i=1; i <= numinds; ++i)
	   for (j=1; j <= numpops; ++j)
	     for (k=0; k < 3; ++k)
	       if ((genosample[i].immanc == j) && (genosample[i].immage == k))
	         ++ anchist[i][j][k];

	 for (i=1; i<=numinds; ++i)
	   for (j=1; j<=numloci; ++j)
	     if (datagone[i][j] == 1)
	       {
		 ++indallhist[i][j][genosample[i].genotype[j][0]];
		 ++indallhist[i][j][genosample[i].genotype[j][1]];
	       }

         for (i=1; i<=numpops; ++i)
	   for (j=1; j<=numpops; ++j)
	     {
	       if ((migmat[i][j] < 0) || (migmat [i][j] > 1))
		 {
		   examplefile << "migmat is not bound between 0 and 1." << '\n' << flush;
		   examplefile << "Values for the faulty migration rates:" << '\n';
		   examplefile << "Migration into " << j << '\n';
		   for (k=1; k<=numpops; ++k)
		     examplefile << "Rate from population " << k << " is " << migmat[k][j] << '\n';
		 }
	       for (m=1; m<=numdivsm; ++m)
		 {
		   bounda = float(m-1) / float(numdivsm);
		   boundb = float(m) / float(numdivsm);
		   if ((bounda <= migmat[i][j]) && (migmat[i][j] < boundb))
		     ++ mfreqhis[i][j][m];
		 }
	       if (migmat[i][j] == 1.0)
		 ++ mfreqhis[i][j][numdivsm];
	       meannewm[i][j] = meanoldm[i][j] + ((migmat[i][j] - meanoldm[i][j]) / float(counter));
	       if (counter >= 2)
		 varnewm[i][j] = ((1.0 - (1.0 / (float(counter) - 1.0))) * varoldm[i][j]) + (float(counter) * (meannewm[i][j] - meanoldm[i][j]) * (meannewm[i][j] - meanoldm[i][j]));
	       meanoldm[i][j] = meannewm[i][j];
	       varoldm[i][j] = varnewm[i][j];
	     }

	 // keep track of non-migration rate values to test whether they are different from the prior

	 for (i=1; i <= numpops; ++i)
	   {
	     //  cout << "migmat " << i << " is " << migmat[i][i] << '\n';
	     for (j=1; j <= 4; ++j)
	       if (migmat[i][i] >= double(j + 7) / 12.0)
		 histprior = j;
	     ++ numberchi[i][histprior];
	     //  cout << "For population " << i << '\n';
	     //  for (j=1; j <= 4; ++j)
	     //  cout << "numberchi " << j << " is " << numberchi[i][j] << '\n';
	     //  cout << '\n';
	   }

	 // keep track of likelihood values so the histogram can be displayed later

	 loglikmt4hist[counterliks] = likmtold;
	 loglikgeno4hist[counterliks] = likgenold;
	 ++ counterliks;
	 if (counterliks == 2000)
	   {
	     counterliks -= 2000;
	     numpassthrough = 1;
	   }

	}
      }
     //#endif
  }      // REMOVE WHILE CHECKING PARTS OF THE PROGRAM SEPARATELY 
   // calculate mode for m

   for (i=1; i<=numpops; ++i)
     for (j=1; j<=numpops; ++j)
       {
	 largest = mfreqhis[i][j][1];
	 mode[i][j] = 1;
	 for (m=2; m<=numdivsm; ++m)
	   {
	     if (mfreqhis[i][j][m] > largest)
	       {
	         largest = mfreqhis[i][j][m];
		 mode[i][j] = m;
	       }
	   }
       }

 // display the summary data

 //  for (i=1; i <= numinds; ++i)
   //  for (j=1; j <= numloci; ++j)
   //  if (datagone[i][j] == 1)
   // for (k=0; k < numalleles[j]; ++k)
   //   examplefile << indallhist[i][j][k] << '\n';

 
 //  examplefile << "Allele probability printouts are for population " << lexWord(popNames, 1) << ", locus " << lexWord(markNames, 2) << ", allele " << lexWord(allList[1], 1) << '\n';
   examplefile << '\n';
   if (allelepost == 1)
     {
   examplefile << "************** ALLELE FREQUENCIES **************" << '\n';
 for (i=1; i<=numpops; ++i)
   {
     examplefile << "for population " << lexWord(popNames, i) << '\n';  // PUT BACK IN!!!
     for (j=1; j<=numloci; ++j)
       {
	 // examplefile << "for locus " << lexWord(markNames, newLname[j]) << '\n';
	 examplefile << "for locus " << lexWord(markNames, j) << '\n';   // PUT BACK IN!!!!
         for (k=0; k<numalleles[j]; ++k)
	   {
	     if (Fafinal == 1)
	       {
		 examplefile << '\n';
                 for (m=1; m<=numdivsp; ++m)
	           {
	             bounda = float(m - 1) / float(numdivsp);
	             boundb = float(m) / float(numdivsp);
		 // examplefile << allfreqhis[i][j][k][m] << '\n';
		 // if (Fafinal == 1)
		     examplefile << "allele " << lexWord(allList[j-1], k+1) << " occured between " << bounda << " and " << boundb << ", " << allfreqhis[i][j][k][m] << " times" << '\n';   // PUT BACK IN!!!
	           }
	       }
	     examplefile << "mean for distribution of allele " << lexWord(allList[j-1], k+1) << " is " << meannew[i][j][k] << " and the sd is " << sqrt(varnew[i][j][k]) << '\n';     // PUT BACK IN!!!!!
	   }
	 examplefile << '\n';
       }
     examplefile << '\n';
   }
     }

   if (Fpost == 1)
     {
 examplefile << "************** F FREQUENCIES **************" << '\n';
 for (i=1; i<=numpops; ++i)
   {
     examplefile << "F values for population " << lexWord(popNames, i) << ": " << '\n'; //   PUT BACK IN!!!!!
     if (Fafinal == 1)
       {
	 examplefile << '\n';
         for (m=(-numdivsF+1); m<=numdivsF; ++m)
           {
	     bounda = float(m-1) / float(numdivsF);
	     boundb = float(m) / float(numdivsF);
	     //	 examplefile << Ffreqhis[i][m] << '\n';
	     //if (Fafinal == 1)
	     examplefile << "F occurred between " << bounda << " and " << boundb << ", " << Ffreqhis[i][m] << " times" << '\n';
	   }
       }
     examplefile << "F mean value for population " << i << " is " << meannewF[i] << " and the sd is " << sqrt(varnewF[i]) << '\n' << '\n'; //  PUT BACK IN!!!
   }
     }
 
 // This next section prints out the allele and F probabilities, so they can be compared between runs in a graph.

   /*
   if (FaFinal == 1)
      {
   examplefile << '\n' << "Allele frequencies are: " << '\n';
   for (i=1; i<=numpops; ++i)
     for (j=1; j<=numloci; ++j)
       for (k=0; k<numalleles[j]; ++k)
         for (m=1; m<=numdivsp; ++m)
           examplefile << allfreqhis[i][j][k][m] << '\n';
   examplefile << '\n' << "F frequencies are:" << '\n';
   for (i=1; i<=numpops; ++i)
     for (m=(-numdivsF+1); m<=numdivsF; ++m)
       examplefile << Ffreqhis[i][m] << '\n';
   examplefile << '\n';
    }
   */

 for (i=1; i<=numinds; ++i)
   if (genosample[i].genotype[1][0] == genosample[i].genotype[1][1])
     for (j=1; j<=numpops; ++j)
       for (k=0; k<3; ++k)
	 ancaccept[k] += anchist[i][j][k];

 for (i=1; i <= numinds; ++i)
   for (j=1; j<=numpops; ++j)
     for (k=0; k<3; ++k)
       pophist[genosample[i].srcpop][j][k] += anchist[i][j][k];

 if (assign == 1)
   {
     examplefile << "************** INDIVIDUAL ASSIGNMENTS **************" << '\n';
 for (i=1; i<=numinds; ++i)
   {
     examplefile << "results for individual " << lexWord(indNames, i) << '\n';
     for (j=1; j<=numpops; ++j)
       for (k=0; k<=2; ++k)
	 if (anchist[i][j][k] != 0)
	   examplefile << "# of times assigned to pop " << j << " at time " << k << " is " << anchist[i][j][k] << '\n';
     if (mdatapost == 1)
       {
     for (j=1; j<=numloci; ++j)
       if (datagone[i][j] == 1)
	 {
	   examplefile << "individual " << lexWord(indNames, i) << " has missing data at locus " << lexWord(markNames, j) << '\n';
	   for (k=0; k<numalleles[j]; ++k)
	     examplefile << "Allele " << lexWord(allList[j-1], k+1) << " was chosen " << indallhist[i][j][k] << " times." << '\n';
	 }
       }
     examplefile << '\n';
   }
   }

 if (popassign == 1)
   {
     examplefile << "************** POPULATION ASSIGNMENT SUMMARIES **************" << '\n';
 for (i=1; i<=numpops; ++i)
   {
     examplefile << "Results for populaton " << lexWord(popNames, i) << ":" << '\n';
     for (j=1; j<=numpops; ++j)
       for (k=0; k<=2; ++k)
	 examplefile << "# of times assigned to pop " << lexWord(popNames, j) << " at time " << k << " is " << pophist[i][j][k] << '\n';
     examplefile << '\n';
   }
 // examplefile << "highest value of loglikmt: " << maxlog << '\n';
 // examplefile << "lowest value of loglikmt: " << minlog << '\n';
   } 

 if (migpost == 1)
   {
     examplefile << "************** MIGRATION RATES **************" << '\n';
 for (j=1; j<=numpops; ++j)
    {
      examplefile << "The migration rates into population " << lexWord(popNames, j) <<  '\n';
      for (i=1; i<=numpops; ++i)
	{
	  examplefile << "   From population " << lexWord(popNames, i) << '\n';
	  if (Fafinal == 1)
	    {
	      examplefile << '\n';
	      for (m=1; m<=numdivsm; ++m)
	        {
	          bounda = float(m-1) / float(numdivsm);
	          boundb = float(m) / float(numdivsm);
	          //   examplefile << mfreqhis[i][j][m] << '\n';
		  //if (Fafinal == 1)
	          examplefile << "This migration rate was between " << bounda << " and " << boundb << ", " << mfreqhis[i][j][m] << " times" << '\n';
	        }
	    }
	  examplefile << "mean for this distribution is " << meannewm[i][j] << ", with a standard deviation of " << sqrt(varnewm[i][j]) << '\n';
	  nmode = (((float)mode[i][j] - 1.0) / (float)numdivsm) + 1.0 / (2.0 * (float)numdivsm); 
	  //  examplefile << "mode for population " << j << " is " << nmode << '\n' << '\n';
	}
      examplefile << '\n';
    }
   }

 // test the change from prior for migration rates

 if (chi2print == 1)
   {
     examplefile << '\n' << "********************* Likelihood ratio test to determine if the migration rates posterior probabilities are significantly different than the prior ********************" << '\n' << '\n';
     // examplefile << "counter is " << counter << '\n';
     for (i=1; i <= numpops; ++i)
       for (j=1; j <= 4; ++j)
         {
           freqchi[i][j] = double(numberchi[i][j]) / double(counter);
	   // examplefile << "freqchi[" << i << "][" << j << "] is " << freqchi[i][j] << '\n';
	   // examplefile << "numberchi[" << i << "][" << j << "] is " << numberchi[i][j] << '\n';
         }
     for (i=1; i <= numpops; ++i)
       {
         chivalue[i] = 0.0;
         for (j=1; j <= 4; ++j)
           {
	     if (numberchi[i][j] > 0)
               chivalue[i] += numberchi[i][j] * log(freqchi[i][j]);
           }
         chivalue[i] -= (double)counter * log(0.25);
         chivalue[i] = 2.0 * chivalue[i];
         examplefile << "chi sq value for population " << i << " is " << chivalue[i];
         if (chivalue[i] < 6.25)
           examplefile << " ***";
	 else if (chivalue[i] < 7.815)
	   examplefile << " **";
	 else if (chivalue[i] < 11.345)
	   examplefile << " *";
         examplefile << '\n';
       }
     examplefile << "*** - not significant at the 10% level" << '\n';
     examplefile << "** - not significant at the 5% level" << '\n';
     examplefile << "* - not significant at the 1% level" << '\n';
     examplefile << "Populations that have a non-significant chi-squared value contain too little information to accurately estimate migration rates" << '\n';
   }


 // create the histogram of likelihood values, and display

 if (Llvaluessum == 1)
   {
     examplefile << '\n' << "******************** LIKELIHOOD FREQUENCIES *********************" << '\n';

     if (numpassthrough == 1)
       numpasses = 2000;
     else
       numpasses = counterliks;
     loglikmtmin = loglikmt4hist[0];
     loglikmtmax = loglikmt4hist[0];
     loglikgenomin = loglikgeno4hist[0];
     loglikgenomax = loglikgeno4hist[0];
 // for (i=0; i < numpasses; ++i)
 //  examplefile << loglikmt4hist[i] << '\n';
 //examplefile << '\n';
 //for (i=0; i < numpasses; ++i)
 //  examplefile << loglikgeno4hist[i] << '\n';
     for (m=1; m <= 20; ++m)
       {
         likmthist[m] = 0;
         likgenohist[m] = 0;
       }
 // for (m=1; m <= 20; ++m)
 //  examplefile << "likmthist is " << likmthist[m] << " and likgenohist is " << likgenohist[m] << '\n';
     for (i=1; i < numpasses; ++i)
       {
         if (loglikmt4hist[i] < loglikmtmin)
           loglikmtmin = loglikmt4hist[i];
         if (loglikmt4hist[i] > loglikmtmax)
           loglikmtmax = loglikmt4hist[i];
         if (loglikgeno4hist[i] < loglikgenomin)
           loglikgenomin = loglikgeno4hist[i];
         if (loglikgeno4hist[i] > loglikgenomax)
           loglikgenomax = loglikgeno4hist[i];
       }
     loglikmtmax += 0.0001;
     loglikgenomax += 0.0001;
     for (i=0; i < numpasses; ++i)
       {
         for (m=1; m <= 20; ++m)
           {
	     bounda = loglikmtmin + float(m-1) * ((loglikmtmax - loglikmtmin) / 20.0);
	     boundb = loglikmtmin + float(m) * ((loglikmtmax - loglikmtmin) / 20.0);
	     if ((bounda <= loglikmt4hist[i]) && (loglikmt4hist[i] < boundb))
	       ++ likmthist[m];
           }
         for (m=1; m <= 20; ++m)
           {
	     bounda = loglikgenomin + float(m-1) * ((loglikgenomax - loglikgenomin) / 20.0);
	     boundb = loglikgenomin + float(m) * ((loglikgenomax - loglikgenomin) / 20.0);
	     if ((bounda <= loglikgeno4hist[i]) && (loglikgeno4hist[i] < boundb))
	       ++ likgenohist[m];
           }
       }
     examplefile << "Log likelihood of (M,t|m)" << '\n';
     for (m=1; m <= 20; ++m)
       {
         bounda = loglikmtmin + float(m-1) * ((loglikmtmax - loglikmtmin) / 20.0);
         boundb = loglikmtmin + float(m) * ((loglikmtmax - loglikmtmin) / 20.0);
         examplefile << "Occurred between " << bounda << " and " << boundb << ", " << likmthist[m] << " times" << '\n';
       }
     examplefile << '\n';
     examplefile << "Log likelihood of (X|S;M,t,F,p)" << '\n';
     for (m=1; m <= 20; ++m)
       {
         bounda = loglikgenomin + float(m-1) * ((loglikgenomax - loglikgenomin) / 20.0);
         boundb = loglikgenomin + float(m) * ((loglikgenomax - loglikgenomin) / 20.0);
         examplefile << "Occurred between " << bounda << " and " << boundb << ", " << likgenohist[m] << " times" << '\n';
       }
     examplefile << '\n';
   }

 // cout << "Log 0 is " << log(0) << '\n';

 if (nchanges == 1)
   {
     examplefile << "************** NUMBER OF CHANGES **************" << '\n';
 examplefile << "P was changed " << pchange << " times." << '\n';
 // for (i=1; i <=numloci; ++i)
 //  examplefile << "  Locus " << i << " was changed " << pchange2[i] << " times." << '\n';
 // examplefile << '\n';
 examplefile << "F was changed " << Fchange << " times." << '\n';
 examplefile << "m was changed " << mchange << " times." << '\n';
   }
 // examplefile << "THIS IS THE END OF THE RUN!!!" << '\n' << '\n' << '\n';
  examplefile.close();  
 cout << "All done now!!" << '\n';
 cout << "Results are in " << ofile << '\n' << '\n';
 free (nalleles);
 // fprintf(outfile, "\n Hello \n");
  return (0);
}

