#include<math.h>
#include<iostream.h>
#include<fstream.h>
#include<iomanip.h>

#define MAXINDS 6000    // maximum number of individuals
#define MAXPOPS 20     // maximum number of populations
#define MAXLOC 40      // maximum number of loci
#define MAXALLELE 40   // maximum number of alleles
#define MAXDIVSP 200    // maximum number of divisions for histogram
#define MAXDIVSF 200    // maximum number of divisions for histogram
#define MAXDIVSM 200    // maximum number of divisions for the histogram
#define MAXSAMP 100000  // maximum number of samples examined
#define MAXANC 5        // maximum age of hybridization estimated
#define MAXLENGTH 256   // maximum length of a string

/******************************************************
 *  greg.h                                            *
 *   This is an include file which defines the        *
 *    structure of the input data, and the various    *
 *    subroutines, for the program greg.cpp, the      *
 *    first version of our assignment test.           *
 ******************************************************/


struct gdata     // data for each individual
{
  int genotype[MAXLOC][2];      // individual's genotype (locus)(alleles)
  long immanc;                  // individual's IMMigrant ANCestry
  long immage;                  // AGE of individual's IMMigrant ancestry 
  long srcpop;                  // SouRCe POPulation for the individual
};

float ran1(long *idum);           // generates random numbers
float gammln(float xx);           // calculates gamma distribution
double loglikmtslow(long anc, long numinds,long numpops,gdata genosample[MAXINDS],double migmat[MAXPOPS][MAXPOPS]);         // calculates log Pr(M, t | m)
double loglikmt(long anc, long numinds, long numpops, gdata genosample[MAXINDS], double migmat[MAXPOPS][MAXPOPS], double gampopsum);
double loglikgeno(long numinds,int numpops,long numloci,gdata genosample[MAXINDS], double migmat[MAXPOPS][MAXPOPS],double pmat[MAXPOPS][MAXLOC][MAXALLELE], double Fvalue[MAXPOPS]);
// calculates log Pr(X | M, t, p, s)
double logprMadj(long anc, long numpops, long cind, gdata genosample[MAXINDS]);   // Metropolis-hastings adjustment for non-symmetry of change of state for immigrant ancestry (when entering or leaving t=0)
double indloglikgeno(long h, long k, gdata genosample[MAXINDS], double migmat[MAXPOPS][MAXPOPS], double pmat[MAXPOPS][MAXLOC][MAXALLELE], double Fvalue[MAXPOPS]);
double loglikgenosum(long numinds, long numloci, double indllgenos[MAXINDS][MAXLOC]);
